package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteStudioResponse(studio: zio.aws.nimble.model.Studio) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.DeleteStudioResponse = {
    import DeleteStudioResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.DeleteStudioResponse
      .builder()
      .studio(studio.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.DeleteStudioResponse.ReadOnly =
    zio.aws.nimble.model.DeleteStudioResponse.wrap(buildAwsValue())
}
object DeleteStudioResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.DeleteStudioResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.DeleteStudioResponse =
      zio.aws.nimble.model.DeleteStudioResponse(studio.asEditable)
    def studio: zio.aws.nimble.model.Studio.ReadOnly
    def getStudio: ZIO[Any, Nothing, zio.aws.nimble.model.Studio.ReadOnly] =
      ZIO.succeed(studio)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStudioResponse
  ) extends zio.aws.nimble.model.DeleteStudioResponse.ReadOnly {
    override val studio: zio.aws.nimble.model.Studio.ReadOnly =
      zio.aws.nimble.model.Studio.wrap(impl.studio())
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStudioResponse
  ): zio.aws.nimble.model.DeleteStudioResponse.ReadOnly = new Wrapper(impl)
}
