package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{EulaName, EulaId, Timestamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Eula(
    content: Option[String] = None,
    createdAt: Option[Timestamp] = None,
    eulaId: Option[EulaId] = None,
    name: Option[EulaName] = None,
    updatedAt: Option[Timestamp] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.nimble.model.Eula = {
    import Eula.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.Eula
      .builder()
      .optionallyWith(content.map(value => value: java.lang.String))(_.content)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        eulaId.map(value => EulaId.unwrap(value): java.lang.String)
      )(_.eulaId)
      .optionallyWith(
        name.map(value => EulaName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.Eula.ReadOnly =
    zio.aws.nimble.model.Eula.wrap(buildAwsValue())
}
object Eula {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.nimble.model.Eula] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.Eula = zio.aws.nimble.model.Eula(
      content.map(value => value),
      createdAt.map(value => value),
      eulaId.map(value => value),
      name.map(value => value),
      updatedAt.map(value => value)
    )
    def content: Option[String]
    def createdAt: Option[Timestamp]
    def eulaId: Option[EulaId]
    def name: Option[EulaName]
    def updatedAt: Option[Timestamp]
    def getContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("content", content)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getEulaId: ZIO[Any, AwsError, EulaId] =
      AwsError.unwrapOptionField("eulaId", eulaId)
    def getName: ZIO[Any, AwsError, EulaName] =
      AwsError.unwrapOptionField("name", name)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.Eula
  ) extends zio.aws.nimble.model.Eula.ReadOnly {
    override val content: Option[String] =
      scala.Option(impl.content()).map(value => value: String)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val eulaId: Option[EulaId] = scala
      .Option(impl.eulaId())
      .map(value => zio.aws.nimble.model.primitives.EulaId(value))
    override val name: Option[EulaName] = scala
      .Option(impl.name())
      .map(value => zio.aws.nimble.model.primitives.EulaName(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.Eula
  ): zio.aws.nimble.model.Eula.ReadOnly = new Wrapper(impl)
}
