package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetEulaResponse(
    eula: Option[zio.aws.nimble.model.Eula] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetEulaResponse = {
    import GetEulaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetEulaResponse
      .builder()
      .optionallyWith(eula.map(value => value.buildAwsValue()))(_.eula)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetEulaResponse.ReadOnly =
    zio.aws.nimble.model.GetEulaResponse.wrap(buildAwsValue())
}
object GetEulaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetEulaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetEulaResponse =
      zio.aws.nimble.model.GetEulaResponse(eula.map(value => value.asEditable))
    def eula: Option[zio.aws.nimble.model.Eula.ReadOnly]
    def getEula: ZIO[Any, AwsError, zio.aws.nimble.model.Eula.ReadOnly] =
      AwsError.unwrapOptionField("eula", eula)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetEulaResponse
  ) extends zio.aws.nimble.model.GetEulaResponse.ReadOnly {
    override val eula: Option[zio.aws.nimble.model.Eula.ReadOnly] = scala
      .Option(impl.eula())
      .map(value => zio.aws.nimble.model.Eula.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetEulaResponse
  ): zio.aws.nimble.model.GetEulaResponse.ReadOnly = new Wrapper(impl)
}
