package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetLaunchProfileInitializationRequest(
    launchProfileId: String,
    launchProfileProtocolVersions: Iterable[String],
    launchPurpose: String,
    platform: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationRequest = {
    import GetLaunchProfileInitializationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationRequest
      .builder()
      .launchProfileId(launchProfileId: java.lang.String)
      .launchProfileProtocolVersions(launchProfileProtocolVersions.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .launchPurpose(launchPurpose: java.lang.String)
      .platform(platform: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.GetLaunchProfileInitializationRequest.ReadOnly =
    zio.aws.nimble.model.GetLaunchProfileInitializationRequest
      .wrap(buildAwsValue())
}
object GetLaunchProfileInitializationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetLaunchProfileInitializationRequest =
      zio.aws.nimble.model.GetLaunchProfileInitializationRequest(
        launchProfileId,
        launchProfileProtocolVersions,
        launchPurpose,
        platform,
        studioId
      )
    def launchProfileId: String
    def launchProfileProtocolVersions: List[String]
    def launchPurpose: String
    def platform: String
    def studioId: String
    def getLaunchProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(launchProfileId)
    def getLaunchProfileProtocolVersions: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(launchProfileProtocolVersions)
    def getLaunchPurpose: ZIO[Any, Nothing, String] = ZIO.succeed(launchPurpose)
    def getPlatform: ZIO[Any, Nothing, String] = ZIO.succeed(platform)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationRequest
  ) extends zio.aws.nimble.model.GetLaunchProfileInitializationRequest.ReadOnly {
    override val launchProfileId: String = impl.launchProfileId(): String
    override val launchProfileProtocolVersions: List[String] = impl
      .launchProfileProtocolVersions()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val launchPurpose: String = impl.launchPurpose(): String
    override val platform: String = impl.platform(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationRequest
  ): zio.aws.nimble.model.GetLaunchProfileInitializationRequest.ReadOnly =
    new Wrapper(impl)
}
