package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetLaunchProfileRequest(
    launchProfileId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetLaunchProfileRequest = {
    import GetLaunchProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileRequest
      .builder()
      .launchProfileId(launchProfileId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetLaunchProfileRequest.ReadOnly =
    zio.aws.nimble.model.GetLaunchProfileRequest.wrap(buildAwsValue())
}
object GetLaunchProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetLaunchProfileRequest =
      zio.aws.nimble.model.GetLaunchProfileRequest(launchProfileId, studioId)
    def launchProfileId: String
    def studioId: String
    def getLaunchProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(launchProfileId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileRequest
  ) extends zio.aws.nimble.model.GetLaunchProfileRequest.ReadOnly {
    override val launchProfileId: String = impl.launchProfileId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileRequest
  ): zio.aws.nimble.model.GetLaunchProfileRequest.ReadOnly = new Wrapper(impl)
}
