package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetStreamingImageResponse(
    streamingImage: Option[zio.aws.nimble.model.StreamingImage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStreamingImageResponse = {
    import GetStreamingImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStreamingImageResponse
      .builder()
      .optionallyWith(streamingImage.map(value => value.buildAwsValue()))(
        _.streamingImage
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetStreamingImageResponse.ReadOnly =
    zio.aws.nimble.model.GetStreamingImageResponse.wrap(buildAwsValue())
}
object GetStreamingImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStreamingImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStreamingImageResponse =
      zio.aws.nimble.model.GetStreamingImageResponse(
        streamingImage.map(value => value.asEditable)
      )
    def streamingImage: Option[zio.aws.nimble.model.StreamingImage.ReadOnly]
    def getStreamingImage
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingImage.ReadOnly] =
      AwsError.unwrapOptionField("streamingImage", streamingImage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingImageResponse
  ) extends zio.aws.nimble.model.GetStreamingImageResponse.ReadOnly {
    override val streamingImage
        : Option[zio.aws.nimble.model.StreamingImage.ReadOnly] = scala
      .Option(impl.streamingImage())
      .map(value => zio.aws.nimble.model.StreamingImage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingImageResponse
  ): zio.aws.nimble.model.GetStreamingImageResponse.ReadOnly = new Wrapper(impl)
}
