package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetStreamingSessionRequest(
    sessionId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStreamingSessionRequest = {
    import GetStreamingSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStreamingSessionRequest
      .builder()
      .sessionId(sessionId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetStreamingSessionRequest.ReadOnly =
    zio.aws.nimble.model.GetStreamingSessionRequest.wrap(buildAwsValue())
}
object GetStreamingSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStreamingSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStreamingSessionRequest =
      zio.aws.nimble.model.GetStreamingSessionRequest(sessionId, studioId)
    def sessionId: String
    def studioId: String
    def getSessionId: ZIO[Any, Nothing, String] = ZIO.succeed(sessionId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingSessionRequest
  ) extends zio.aws.nimble.model.GetStreamingSessionRequest.ReadOnly {
    override val sessionId: String = impl.sessionId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingSessionRequest
  ): zio.aws.nimble.model.GetStreamingSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
