package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetStreamingSessionResponse(
    session: Option[zio.aws.nimble.model.StreamingSession] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStreamingSessionResponse = {
    import GetStreamingSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStreamingSessionResponse
      .builder()
      .optionallyWith(session.map(value => value.buildAwsValue()))(_.session)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetStreamingSessionResponse.ReadOnly =
    zio.aws.nimble.model.GetStreamingSessionResponse.wrap(buildAwsValue())
}
object GetStreamingSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStreamingSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStreamingSessionResponse =
      zio.aws.nimble.model
        .GetStreamingSessionResponse(session.map(value => value.asEditable))
    def session: Option[zio.aws.nimble.model.StreamingSession.ReadOnly]
    def getSession
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingSession.ReadOnly] =
      AwsError.unwrapOptionField("session", session)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingSessionResponse
  ) extends zio.aws.nimble.model.GetStreamingSessionResponse.ReadOnly {
    override val session
        : Option[zio.aws.nimble.model.StreamingSession.ReadOnly] = scala
      .Option(impl.session())
      .map(value => zio.aws.nimble.model.StreamingSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingSessionResponse
  ): zio.aws.nimble.model.GetStreamingSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
