package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetStudioComponentResponse(
    studioComponent: Option[zio.aws.nimble.model.StudioComponent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStudioComponentResponse = {
    import GetStudioComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStudioComponentResponse
      .builder()
      .optionallyWith(studioComponent.map(value => value.buildAwsValue()))(
        _.studioComponent
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetStudioComponentResponse.ReadOnly =
    zio.aws.nimble.model.GetStudioComponentResponse.wrap(buildAwsValue())
}
object GetStudioComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStudioComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStudioComponentResponse =
      zio.aws.nimble.model.GetStudioComponentResponse(
        studioComponent.map(value => value.asEditable)
      )
    def studioComponent: Option[zio.aws.nimble.model.StudioComponent.ReadOnly]
    def getStudioComponent
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponent.ReadOnly] =
      AwsError.unwrapOptionField("studioComponent", studioComponent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStudioComponentResponse
  ) extends zio.aws.nimble.model.GetStudioComponentResponse.ReadOnly {
    override val studioComponent
        : Option[zio.aws.nimble.model.StudioComponent.ReadOnly] = scala
      .Option(impl.studioComponent())
      .map(value => zio.aws.nimble.model.StudioComponent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStudioComponentResponse
  ): zio.aws.nimble.model.GetStudioComponentResponse.ReadOnly = new Wrapper(
    impl
  )
}
