package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetStudioRequest(studioId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStudioRequest = {
    import GetStudioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStudioRequest
      .builder()
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetStudioRequest.ReadOnly =
    zio.aws.nimble.model.GetStudioRequest.wrap(buildAwsValue())
}
object GetStudioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStudioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStudioRequest =
      zio.aws.nimble.model.GetStudioRequest(studioId)
    def studioId: String
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStudioRequest
  ) extends zio.aws.nimble.model.GetStudioRequest.ReadOnly {
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStudioRequest
  ): zio.aws.nimble.model.GetStudioRequest.ReadOnly = new Wrapper(impl)
}
