package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  LaunchProfileName,
  SecurityGroupId,
  LaunchPurpose,
  LaunchProfileId,
  LaunchProfileProtocolVersion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LaunchProfileInitialization(
    activeDirectory: Option[
      zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory
    ] = None,
    ec2SecurityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    launchProfileId: Option[LaunchProfileId] = None,
    launchProfileProtocolVersion: Option[LaunchProfileProtocolVersion] = None,
    launchPurpose: Option[LaunchPurpose] = None,
    name: Option[LaunchProfileName] = None,
    platform: Option[zio.aws.nimble.model.LaunchProfilePlatform] = None,
    systemInitializationScripts: Option[
      Iterable[zio.aws.nimble.model.LaunchProfileInitializationScript]
    ] = None,
    userInitializationScripts: Option[
      Iterable[zio.aws.nimble.model.LaunchProfileInitializationScript]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.LaunchProfileInitialization = {
    import LaunchProfileInitialization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.LaunchProfileInitialization
      .builder()
      .optionallyWith(activeDirectory.map(value => value.buildAwsValue()))(
        _.activeDirectory
      )
      .optionallyWith(
        ec2SecurityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ec2SecurityGroupIds)
      .optionallyWith(
        launchProfileId.map(value =>
          LaunchProfileId.unwrap(value): java.lang.String
        )
      )(_.launchProfileId)
      .optionallyWith(
        launchProfileProtocolVersion.map(value =>
          LaunchProfileProtocolVersion.unwrap(value): java.lang.String
        )
      )(_.launchProfileProtocolVersion)
      .optionallyWith(
        launchPurpose.map(value =>
          LaunchPurpose.unwrap(value): java.lang.String
        )
      )(_.launchPurpose)
      .optionallyWith(
        name.map(value => LaunchProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        systemInitializationScripts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.systemInitializationScripts)
      .optionallyWith(
        userInitializationScripts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userInitializationScripts)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.LaunchProfileInitialization.ReadOnly =
    zio.aws.nimble.model.LaunchProfileInitialization.wrap(buildAwsValue())
}
object LaunchProfileInitialization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.LaunchProfileInitialization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.LaunchProfileInitialization =
      zio.aws.nimble.model.LaunchProfileInitialization(
        activeDirectory.map(value => value.asEditable),
        ec2SecurityGroupIds.map(value => value),
        launchProfileId.map(value => value),
        launchProfileProtocolVersion.map(value => value),
        launchPurpose.map(value => value),
        name.map(value => value),
        platform.map(value => value),
        systemInitializationScripts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userInitializationScripts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def activeDirectory: Option[
      zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory.ReadOnly
    ]
    def ec2SecurityGroupIds: Option[List[SecurityGroupId]]
    def launchProfileId: Option[LaunchProfileId]
    def launchProfileProtocolVersion: Option[LaunchProfileProtocolVersion]
    def launchPurpose: Option[LaunchPurpose]
    def name: Option[LaunchProfileName]
    def platform: Option[zio.aws.nimble.model.LaunchProfilePlatform]
    def systemInitializationScripts: Option[
      List[zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly]
    ]
    def userInitializationScripts: Option[
      List[zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly]
    ]
    def getActiveDirectory: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory.ReadOnly
    ] = AwsError.unwrapOptionField("activeDirectory", activeDirectory)
    def getEc2SecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("ec2SecurityGroupIds", ec2SecurityGroupIds)
    def getLaunchProfileId: ZIO[Any, AwsError, LaunchProfileId] =
      AwsError.unwrapOptionField("launchProfileId", launchProfileId)
    def getLaunchProfileProtocolVersion
        : ZIO[Any, AwsError, LaunchProfileProtocolVersion] =
      AwsError.unwrapOptionField(
        "launchProfileProtocolVersion",
        launchProfileProtocolVersion
      )
    def getLaunchPurpose: ZIO[Any, AwsError, LaunchPurpose] =
      AwsError.unwrapOptionField("launchPurpose", launchPurpose)
    def getName: ZIO[Any, AwsError, LaunchProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getPlatform
        : ZIO[Any, AwsError, zio.aws.nimble.model.LaunchProfilePlatform] =
      AwsError.unwrapOptionField("platform", platform)
    def getSystemInitializationScripts: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "systemInitializationScripts",
      systemInitializationScripts
    )
    def getUserInitializationScripts: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "userInitializationScripts",
      userInitializationScripts
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfileInitialization
  ) extends zio.aws.nimble.model.LaunchProfileInitialization.ReadOnly {
    override val activeDirectory: Option[
      zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory.ReadOnly
    ] = scala
      .Option(impl.activeDirectory())
      .map(value =>
        zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory
          .wrap(value)
      )
    override val ec2SecurityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.ec2SecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val launchProfileId: Option[LaunchProfileId] = scala
      .Option(impl.launchProfileId())
      .map(value => zio.aws.nimble.model.primitives.LaunchProfileId(value))
    override val launchProfileProtocolVersion
        : Option[LaunchProfileProtocolVersion] = scala
      .Option(impl.launchProfileProtocolVersion())
      .map(value =>
        zio.aws.nimble.model.primitives.LaunchProfileProtocolVersion(value)
      )
    override val launchPurpose: Option[LaunchPurpose] = scala
      .Option(impl.launchPurpose())
      .map(value => zio.aws.nimble.model.primitives.LaunchPurpose(value))
    override val name: Option[LaunchProfileName] = scala
      .Option(impl.name())
      .map(value => zio.aws.nimble.model.primitives.LaunchProfileName(value))
    override val platform: Option[zio.aws.nimble.model.LaunchProfilePlatform] =
      scala
        .Option(impl.platform())
        .map(value => zio.aws.nimble.model.LaunchProfilePlatform.wrap(value))
    override val systemInitializationScripts: Option[
      List[zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly]
    ] = scala
      .Option(impl.systemInitializationScripts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.LaunchProfileInitializationScript.wrap(item)
        }.toList
      )
    override val userInitializationScripts: Option[
      List[zio.aws.nimble.model.LaunchProfileInitializationScript.ReadOnly]
    ] = scala
      .Option(impl.userInitializationScripts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.LaunchProfileInitializationScript.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfileInitialization
  ): zio.aws.nimble.model.LaunchProfileInitialization.ReadOnly = new Wrapper(
    impl
  )
}
