package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StudioComponentName,
  ActiveDirectoryOrganizationalUnitDistinguishedName,
  StudioComponentId,
  ActiveDirectoryDnsIpAddress,
  DirectoryId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LaunchProfileInitializationActiveDirectory(
    computerAttributes: Option[
      Iterable[zio.aws.nimble.model.ActiveDirectoryComputerAttribute]
    ] = None,
    directoryId: Option[DirectoryId] = None,
    directoryName: Option[String] = None,
    dnsIpAddresses: Option[Iterable[ActiveDirectoryDnsIpAddress]] = None,
    organizationalUnitDistinguishedName: Option[
      ActiveDirectoryOrganizationalUnitDistinguishedName
    ] = None,
    studioComponentId: Option[StudioComponentId] = None,
    studioComponentName: Option[StudioComponentName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationActiveDirectory = {
    import LaunchProfileInitializationActiveDirectory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationActiveDirectory
      .builder()
      .optionallyWith(
        computerAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.computerAttributes)
      .optionallyWith(
        directoryId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.directoryId)
      .optionallyWith(directoryName.map(value => value: java.lang.String))(
        _.directoryName
      )
      .optionallyWith(
        dnsIpAddresses.map(value =>
          value.map { item =>
            ActiveDirectoryDnsIpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsIpAddresses)
      .optionallyWith(
        organizationalUnitDistinguishedName.map(value =>
          ActiveDirectoryOrganizationalUnitDistinguishedName.unwrap(
            value
          ): java.lang.String
        )
      )(_.organizationalUnitDistinguishedName)
      .optionallyWith(
        studioComponentId.map(value =>
          StudioComponentId.unwrap(value): java.lang.String
        )
      )(_.studioComponentId)
      .optionallyWith(
        studioComponentName.map(value =>
          StudioComponentName.unwrap(value): java.lang.String
        )
      )(_.studioComponentName)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory.ReadOnly =
    zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory
      .wrap(buildAwsValue())
}
object LaunchProfileInitializationActiveDirectory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationActiveDirectory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory =
      zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory(
        computerAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        directoryId.map(value => value),
        directoryName.map(value => value),
        dnsIpAddresses.map(value => value),
        organizationalUnitDistinguishedName.map(value => value),
        studioComponentId.map(value => value),
        studioComponentName.map(value => value)
      )
    def computerAttributes: Option[
      List[zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly]
    ]
    def directoryId: Option[DirectoryId]
    def directoryName: Option[String]
    def dnsIpAddresses: Option[List[ActiveDirectoryDnsIpAddress]]
    def organizationalUnitDistinguishedName
        : Option[ActiveDirectoryOrganizationalUnitDistinguishedName]
    def studioComponentId: Option[StudioComponentId]
    def studioComponentName: Option[StudioComponentName]
    def getComputerAttributes: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("computerAttributes", computerAttributes)
    def getDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("directoryId", directoryId)
    def getDirectoryName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("directoryName", directoryName)
    def getDnsIpAddresses
        : ZIO[Any, AwsError, List[ActiveDirectoryDnsIpAddress]] =
      AwsError.unwrapOptionField("dnsIpAddresses", dnsIpAddresses)
    def getOrganizationalUnitDistinguishedName: ZIO[
      Any,
      AwsError,
      ActiveDirectoryOrganizationalUnitDistinguishedName
    ] = AwsError.unwrapOptionField(
      "organizationalUnitDistinguishedName",
      organizationalUnitDistinguishedName
    )
    def getStudioComponentId: ZIO[Any, AwsError, StudioComponentId] =
      AwsError.unwrapOptionField("studioComponentId", studioComponentId)
    def getStudioComponentName: ZIO[Any, AwsError, StudioComponentName] =
      AwsError.unwrapOptionField("studioComponentName", studioComponentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationActiveDirectory
  ) extends zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory.ReadOnly {
    override val computerAttributes: Option[
      List[zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly]
    ] = scala
      .Option(impl.computerAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.ActiveDirectoryComputerAttribute.wrap(item)
        }.toList
      )
    override val directoryId: Option[DirectoryId] = scala
      .Option(impl.directoryId())
      .map(value => zio.aws.nimble.model.primitives.DirectoryId(value))
    override val directoryName: Option[String] =
      scala.Option(impl.directoryName()).map(value => value: String)
    override val dnsIpAddresses: Option[List[ActiveDirectoryDnsIpAddress]] =
      scala
        .Option(impl.dnsIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.primitives.ActiveDirectoryDnsIpAddress(item)
          }.toList
        )
    override val organizationalUnitDistinguishedName
        : Option[ActiveDirectoryOrganizationalUnitDistinguishedName] = scala
      .Option(impl.organizationalUnitDistinguishedName())
      .map(value =>
        zio.aws.nimble.model.primitives
          .ActiveDirectoryOrganizationalUnitDistinguishedName(value)
      )
    override val studioComponentId: Option[StudioComponentId] = scala
      .Option(impl.studioComponentId())
      .map(value => zio.aws.nimble.model.primitives.StudioComponentId(value))
    override val studioComponentName: Option[StudioComponentName] = scala
      .Option(impl.studioComponentName())
      .map(value => zio.aws.nimble.model.primitives.StudioComponentName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfileInitializationActiveDirectory
  ): zio.aws.nimble.model.LaunchProfileInitializationActiveDirectory.ReadOnly =
    new Wrapper(impl)
}
