package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait LaunchProfilePersona {
  def unwrap: software.amazon.awssdk.services.nimble.model.LaunchProfilePersona
}
object LaunchProfilePersona {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.LaunchProfilePersona
  ): zio.aws.nimble.model.LaunchProfilePersona = value match {
    case software.amazon.awssdk.services.nimble.model.LaunchProfilePersona.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfilePersona.USER =>
      val r = USER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.LaunchProfilePersona {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfilePersona =
      software.amazon.awssdk.services.nimble.model.LaunchProfilePersona.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.nimble.model.LaunchProfilePersona {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfilePersona =
      software.amazon.awssdk.services.nimble.model.LaunchProfilePersona.USER
  }
}
