package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait LaunchProfilePlatform {
  def unwrap: software.amazon.awssdk.services.nimble.model.LaunchProfilePlatform
}
object LaunchProfilePlatform {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.LaunchProfilePlatform
  ): zio.aws.nimble.model.LaunchProfilePlatform = value match {
    case software.amazon.awssdk.services.nimble.model.LaunchProfilePlatform.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfilePlatform.LINUX =>
      val r = LINUX
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfilePlatform.WINDOWS =>
      val r = WINDOWS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.LaunchProfilePlatform {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfilePlatform =
      software.amazon.awssdk.services.nimble.model.LaunchProfilePlatform.UNKNOWN_TO_SDK_VERSION
  }
  case object LINUX extends zio.aws.nimble.model.LaunchProfilePlatform {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfilePlatform =
      software.amazon.awssdk.services.nimble.model.LaunchProfilePlatform.LINUX
  }
  case object WINDOWS extends zio.aws.nimble.model.LaunchProfilePlatform {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfilePlatform =
      software.amazon.awssdk.services.nimble.model.LaunchProfilePlatform.WINDOWS
  }
}
