package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait LaunchProfileStatusCode {
  def unwrap
      : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode
}
object LaunchProfileStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode
  ): zio.aws.nimble.model.LaunchProfileStatusCode = value match {
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_CREATED =>
      val r = LAUNCH_PROFILE_CREATED
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_UPDATED =>
      val r = LAUNCH_PROFILE_UPDATED
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_DELETED =>
      val r = LAUNCH_PROFILE_DELETED
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_CREATE_IN_PROGRESS =>
      val r = LAUNCH_PROFILE_CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_UPDATE_IN_PROGRESS =>
      val r = LAUNCH_PROFILE_UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_DELETE_IN_PROGRESS =>
      val r = LAUNCH_PROFILE_DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.STREAMING_IMAGE_NOT_FOUND =>
      val r = STREAMING_IMAGE_NOT_FOUND
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.STREAMING_IMAGE_NOT_READY =>
      val r = STREAMING_IMAGE_NOT_READY
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_WITH_STREAM_SESSIONS_NOT_DELETED =>
      val r = LAUNCH_PROFILE_WITH_STREAM_SESSIONS_NOT_DELETED
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.ENCRYPTION_KEY_ACCESS_DENIED =>
      val r = ENCRYPTION_KEY_ACCESS_DENIED
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.ENCRYPTION_KEY_NOT_FOUND =>
      val r = ENCRYPTION_KEY_NOT_FOUND
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.INVALID_SUBNETS_PROVIDED =>
      val r = INVALID_SUBNETS_PROVIDED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object LAUNCH_PROFILE_CREATED
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_CREATED
  }
  case object LAUNCH_PROFILE_UPDATED
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_UPDATED
  }
  case object LAUNCH_PROFILE_DELETED
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_DELETED
  }
  case object LAUNCH_PROFILE_CREATE_IN_PROGRESS
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_CREATE_IN_PROGRESS
  }
  case object LAUNCH_PROFILE_UPDATE_IN_PROGRESS
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_UPDATE_IN_PROGRESS
  }
  case object LAUNCH_PROFILE_DELETE_IN_PROGRESS
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_DELETE_IN_PROGRESS
  }
  case object INTERNAL_ERROR
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.INTERNAL_ERROR
  }
  case object STREAMING_IMAGE_NOT_FOUND
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.STREAMING_IMAGE_NOT_FOUND
  }
  case object STREAMING_IMAGE_NOT_READY
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.STREAMING_IMAGE_NOT_READY
  }
  case object LAUNCH_PROFILE_WITH_STREAM_SESSIONS_NOT_DELETED
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.LAUNCH_PROFILE_WITH_STREAM_SESSIONS_NOT_DELETED
  }
  case object ENCRYPTION_KEY_ACCESS_DENIED
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.ENCRYPTION_KEY_ACCESS_DENIED
  }
  case object ENCRYPTION_KEY_NOT_FOUND
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.ENCRYPTION_KEY_NOT_FOUND
  }
  case object INVALID_SUBNETS_PROVIDED
      extends zio.aws.nimble.model.LaunchProfileStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode.INVALID_SUBNETS_PROVIDED
  }
}
