package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait LaunchProfileValidationState {
  def unwrap: software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState
}
object LaunchProfileValidationState {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState
  ): zio.aws.nimble.model.LaunchProfileValidationState = value match {
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState.VALIDATION_NOT_STARTED =>
      val r = VALIDATION_NOT_STARTED
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState.VALIDATION_IN_PROGRESS =>
      val r = VALIDATION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState.VALIDATION_SUCCESS =>
      val r = VALIDATION_SUCCESS
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState.VALIDATION_FAILED =>
      val r = VALIDATION_FAILED
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState.VALIDATION_FAILED_INTERNAL_SERVER_ERROR =>
      val r = VALIDATION_FAILED_INTERNAL_SERVER_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.LaunchProfileValidationState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState.UNKNOWN_TO_SDK_VERSION
  }
  case object VALIDATION_NOT_STARTED
      extends zio.aws.nimble.model.LaunchProfileValidationState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState.VALIDATION_NOT_STARTED
  }
  case object VALIDATION_IN_PROGRESS
      extends zio.aws.nimble.model.LaunchProfileValidationState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState.VALIDATION_IN_PROGRESS
  }
  case object VALIDATION_SUCCESS
      extends zio.aws.nimble.model.LaunchProfileValidationState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState.VALIDATION_SUCCESS
  }
  case object VALIDATION_FAILED
      extends zio.aws.nimble.model.LaunchProfileValidationState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState.VALIDATION_FAILED
  }
  case object VALIDATION_FAILED_INTERNAL_SERVER_ERROR
      extends zio.aws.nimble.model.LaunchProfileValidationState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationState.VALIDATION_FAILED_INTERNAL_SERVER_ERROR
  }
}
