package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait LaunchProfileValidationStatusCode {
  def unwrap: software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode
}
object LaunchProfileValidationStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode
  ): zio.aws.nimble.model.LaunchProfileValidationStatusCode = value match {
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_NOT_STARTED =>
      val r = VALIDATION_NOT_STARTED
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_IN_PROGRESS =>
      val r = VALIDATION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_SUCCESS =>
      val r = VALIDATION_SUCCESS
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_FAILED_INVALID_SUBNET_ROUTE_TABLE_ASSOCIATION =>
      val r = VALIDATION_FAILED_INVALID_SUBNET_ROUTE_TABLE_ASSOCIATION
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_FAILED_SUBNET_NOT_FOUND =>
      val r = VALIDATION_FAILED_SUBNET_NOT_FOUND
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_FAILED_INVALID_SECURITY_GROUP_ASSOCIATION =>
      val r = VALIDATION_FAILED_INVALID_SECURITY_GROUP_ASSOCIATION
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_FAILED_INVALID_ACTIVE_DIRECTORY =>
      val r = VALIDATION_FAILED_INVALID_ACTIVE_DIRECTORY
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_FAILED_UNAUTHORIZED =>
      val r = VALIDATION_FAILED_UNAUTHORIZED
      r
    case software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_FAILED_INTERNAL_SERVER_ERROR =>
      val r = VALIDATION_FAILED_INTERNAL_SERVER_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.LaunchProfileValidationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object VALIDATION_NOT_STARTED
      extends zio.aws.nimble.model.LaunchProfileValidationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_NOT_STARTED
  }
  case object VALIDATION_IN_PROGRESS
      extends zio.aws.nimble.model.LaunchProfileValidationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_IN_PROGRESS
  }
  case object VALIDATION_SUCCESS
      extends zio.aws.nimble.model.LaunchProfileValidationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_SUCCESS
  }
  case object VALIDATION_FAILED_INVALID_SUBNET_ROUTE_TABLE_ASSOCIATION
      extends zio.aws.nimble.model.LaunchProfileValidationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_FAILED_INVALID_SUBNET_ROUTE_TABLE_ASSOCIATION
  }
  case object VALIDATION_FAILED_SUBNET_NOT_FOUND
      extends zio.aws.nimble.model.LaunchProfileValidationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_FAILED_SUBNET_NOT_FOUND
  }
  case object VALIDATION_FAILED_INVALID_SECURITY_GROUP_ASSOCIATION
      extends zio.aws.nimble.model.LaunchProfileValidationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_FAILED_INVALID_SECURITY_GROUP_ASSOCIATION
  }
  case object VALIDATION_FAILED_INVALID_ACTIVE_DIRECTORY
      extends zio.aws.nimble.model.LaunchProfileValidationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_FAILED_INVALID_ACTIVE_DIRECTORY
  }
  case object VALIDATION_FAILED_UNAUTHORIZED
      extends zio.aws.nimble.model.LaunchProfileValidationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_FAILED_UNAUTHORIZED
  }
  case object VALIDATION_FAILED_INTERNAL_SERVER_ERROR
      extends zio.aws.nimble.model.LaunchProfileValidationStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode =
      software.amazon.awssdk.services.nimble.model.LaunchProfileValidationStatusCode.VALIDATION_FAILED_INTERNAL_SERVER_ERROR
  }
}
