package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListEulaAcceptancesResponse(
    eulaAcceptances: Option[Iterable[zio.aws.nimble.model.EulaAcceptance]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse = {
    import ListEulaAcceptancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse
      .builder()
      .optionallyWith(
        eulaAcceptances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eulaAcceptances)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListEulaAcceptancesResponse.ReadOnly =
    zio.aws.nimble.model.ListEulaAcceptancesResponse.wrap(buildAwsValue())
}
object ListEulaAcceptancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListEulaAcceptancesResponse =
      zio.aws.nimble.model.ListEulaAcceptancesResponse(
        eulaAcceptances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eulaAcceptances
        : Option[List[zio.aws.nimble.model.EulaAcceptance.ReadOnly]]
    def nextToken: Option[String]
    def getEulaAcceptances: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.EulaAcceptance.ReadOnly
    ]] = AwsError.unwrapOptionField("eulaAcceptances", eulaAcceptances)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse
  ) extends zio.aws.nimble.model.ListEulaAcceptancesResponse.ReadOnly {
    override val eulaAcceptances
        : Option[List[zio.aws.nimble.model.EulaAcceptance.ReadOnly]] = scala
      .Option(impl.eulaAcceptances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.EulaAcceptance.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse
  ): zio.aws.nimble.model.ListEulaAcceptancesResponse.ReadOnly = new Wrapper(
    impl
  )
}
