package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListLaunchProfileMembersResponse(
    members: Option[Iterable[zio.aws.nimble.model.LaunchProfileMembership]] =
      None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse = {
    import ListLaunchProfileMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse
      .builder()
      .optionallyWith(
        members.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.members)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.ListLaunchProfileMembersResponse.ReadOnly =
    zio.aws.nimble.model.ListLaunchProfileMembersResponse.wrap(buildAwsValue())
}
object ListLaunchProfileMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListLaunchProfileMembersResponse =
      zio.aws.nimble.model.ListLaunchProfileMembersResponse(
        members.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def members
        : Option[List[zio.aws.nimble.model.LaunchProfileMembership.ReadOnly]]
    def nextToken: Option[String]
    def getMembers: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.LaunchProfileMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("members", members)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse
  ) extends zio.aws.nimble.model.ListLaunchProfileMembersResponse.ReadOnly {
    override val members
        : Option[List[zio.aws.nimble.model.LaunchProfileMembership.ReadOnly]] =
      scala
        .Option(impl.members())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.LaunchProfileMembership.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse
  ): zio.aws.nimble.model.ListLaunchProfileMembersResponse.ReadOnly =
    new Wrapper(impl)
}
