package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListStreamingSessionsRequest(
    createdBy: Option[String] = None,
    nextToken: Option[String] = None,
    ownedBy: Option[String] = None,
    sessionIds: Option[String] = None,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest = {
    import ListStreamingSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest
      .builder()
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(ownedBy.map(value => value: java.lang.String))(_.ownedBy)
      .optionallyWith(sessionIds.map(value => value: java.lang.String))(
        _.sessionIds
      )
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStreamingSessionsRequest.ReadOnly =
    zio.aws.nimble.model.ListStreamingSessionsRequest.wrap(buildAwsValue())
}
object ListStreamingSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStreamingSessionsRequest =
      zio.aws.nimble.model.ListStreamingSessionsRequest(
        createdBy.map(value => value),
        nextToken.map(value => value),
        ownedBy.map(value => value),
        sessionIds.map(value => value),
        studioId
      )
    def createdBy: Option[String]
    def nextToken: Option[String]
    def ownedBy: Option[String]
    def sessionIds: Option[String]
    def studioId: String
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOwnedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownedBy", ownedBy)
    def getSessionIds: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionIds", sessionIds)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest
  ) extends zio.aws.nimble.model.ListStreamingSessionsRequest.ReadOnly {
    override val createdBy: Option[String] =
      scala.Option(impl.createdBy()).map(value => value: String)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val ownedBy: Option[String] =
      scala.Option(impl.ownedBy()).map(value => value: String)
    override val sessionIds: Option[String] =
      scala.Option(impl.sessionIds()).map(value => value: String)
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest
  ): zio.aws.nimble.model.ListStreamingSessionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
