package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListStreamingSessionsResponse(
    nextToken: Option[String] = None,
    sessions: Option[Iterable[zio.aws.nimble.model.StreamingSession]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse = {
    import ListStreamingSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        sessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sessions)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStreamingSessionsResponse.ReadOnly =
    zio.aws.nimble.model.ListStreamingSessionsResponse.wrap(buildAwsValue())
}
object ListStreamingSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStreamingSessionsResponse =
      zio.aws.nimble.model.ListStreamingSessionsResponse(
        nextToken.map(value => value),
        sessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def sessions: Option[List[zio.aws.nimble.model.StreamingSession.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSessions: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StreamingSession.ReadOnly
    ]] = AwsError.unwrapOptionField("sessions", sessions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse
  ) extends zio.aws.nimble.model.ListStreamingSessionsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val sessions
        : Option[List[zio.aws.nimble.model.StreamingSession.ReadOnly]] = scala
      .Option(impl.sessions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.StreamingSession.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse
  ): zio.aws.nimble.model.ListStreamingSessionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
