package zio.aws.nimble.model
import java.lang.Integer
import zio.aws.nimble.model.primitives.MaxResults
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListStudioComponentsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[String] = None,
    states: Option[Iterable[zio.aws.nimble.model.StudioComponentState]] = None,
    studioId: String,
    types: Option[Iterable[zio.aws.nimble.model.StudioComponentType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest = {
    import ListStudioComponentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .studioId(studioId: java.lang.String)
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.typesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStudioComponentsRequest.ReadOnly =
    zio.aws.nimble.model.ListStudioComponentsRequest.wrap(buildAwsValue())
}
object ListStudioComponentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStudioComponentsRequest =
      zio.aws.nimble.model.ListStudioComponentsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        states.map(value => value),
        studioId,
        types.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[String]
    def states: Option[List[zio.aws.nimble.model.StudioComponentState]]
    def studioId: String
    def types: Option[List[zio.aws.nimble.model.StudioComponentType]]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStates
        : ZIO[Any, AwsError, List[zio.aws.nimble.model.StudioComponentState]] =
      AwsError.unwrapOptionField("states", states)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
    def getTypes
        : ZIO[Any, AwsError, List[zio.aws.nimble.model.StudioComponentType]] =
      AwsError.unwrapOptionField("types", types)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest
  ) extends zio.aws.nimble.model.ListStudioComponentsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.nimble.model.primitives.MaxResults(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val states
        : Option[List[zio.aws.nimble.model.StudioComponentState]] = scala
      .Option(impl.states())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.StudioComponentState.wrap(item)
        }.toList
      )
    override val studioId: String = impl.studioId(): String
    override val types: Option[List[zio.aws.nimble.model.StudioComponentType]] =
      scala
        .Option(impl.types())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.StudioComponentType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest
  ): zio.aws.nimble.model.ListStudioComponentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
