package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListStudioComponentsResponse(
    nextToken: Option[String] = None,
    studioComponents: Option[Iterable[zio.aws.nimble.model.StudioComponent]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse = {
    import ListStudioComponentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        studioComponents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.studioComponents)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStudioComponentsResponse.ReadOnly =
    zio.aws.nimble.model.ListStudioComponentsResponse.wrap(buildAwsValue())
}
object ListStudioComponentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStudioComponentsResponse =
      zio.aws.nimble.model.ListStudioComponentsResponse(
        nextToken.map(value => value),
        studioComponents.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def studioComponents
        : Option[List[zio.aws.nimble.model.StudioComponent.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStudioComponents: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StudioComponent.ReadOnly
    ]] = AwsError.unwrapOptionField("studioComponents", studioComponents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse
  ) extends zio.aws.nimble.model.ListStudioComponentsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val studioComponents
        : Option[List[zio.aws.nimble.model.StudioComponent.ReadOnly]] = scala
      .Option(impl.studioComponents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.StudioComponent.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse
  ): zio.aws.nimble.model.ListStudioComponentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
