package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListStudiosRequest(nextToken: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStudiosRequest = {
    import ListStudiosRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStudiosRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStudiosRequest.ReadOnly =
    zio.aws.nimble.model.ListStudiosRequest.wrap(buildAwsValue())
}
object ListStudiosRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStudiosRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStudiosRequest =
      zio.aws.nimble.model.ListStudiosRequest(nextToken.map(value => value))
    def nextToken: Option[String]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStudiosRequest
  ) extends zio.aws.nimble.model.ListStudiosRequest.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStudiosRequest
  ): zio.aws.nimble.model.ListStudiosRequest.ReadOnly = new Wrapper(impl)
}
