package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.nimble.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListTagsForResourceResponse =
      zio.aws.nimble.model.ListTagsForResourceResponse(tags.map(value => value))
    def tags: Option[Map[String, String]]
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListTagsForResourceResponse
  ) extends zio.aws.nimble.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListTagsForResourceResponse
  ): zio.aws.nimble.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
