package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class NewLaunchProfileMember(
    persona: zio.aws.nimble.model.LaunchProfilePersona,
    principalId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.NewLaunchProfileMember = {
    import NewLaunchProfileMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.NewLaunchProfileMember
      .builder()
      .persona(persona.unwrap)
      .principalId(principalId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.NewLaunchProfileMember.ReadOnly =
    zio.aws.nimble.model.NewLaunchProfileMember.wrap(buildAwsValue())
}
object NewLaunchProfileMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.NewLaunchProfileMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.NewLaunchProfileMember =
      zio.aws.nimble.model.NewLaunchProfileMember(persona, principalId)
    def persona: zio.aws.nimble.model.LaunchProfilePersona
    def principalId: String
    def getPersona
        : ZIO[Any, Nothing, zio.aws.nimble.model.LaunchProfilePersona] =
      ZIO.succeed(persona)
    def getPrincipalId: ZIO[Any, Nothing, String] = ZIO.succeed(principalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.NewLaunchProfileMember
  ) extends zio.aws.nimble.model.NewLaunchProfileMember.ReadOnly {
    override val persona: zio.aws.nimble.model.LaunchProfilePersona =
      zio.aws.nimble.model.LaunchProfilePersona.wrap(impl.persona())
    override val principalId: String = impl.principalId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.NewLaunchProfileMember
  ): zio.aws.nimble.model.NewLaunchProfileMember.ReadOnly = new Wrapper(impl)
}
