package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class NewStudioMember(
    persona: zio.aws.nimble.model.StudioPersona,
    principalId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.NewStudioMember = {
    import NewStudioMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.NewStudioMember
      .builder()
      .persona(persona.unwrap)
      .principalId(principalId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.NewStudioMember.ReadOnly =
    zio.aws.nimble.model.NewStudioMember.wrap(buildAwsValue())
}
object NewStudioMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.NewStudioMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.NewStudioMember =
      zio.aws.nimble.model.NewStudioMember(persona, principalId)
    def persona: zio.aws.nimble.model.StudioPersona
    def principalId: String
    def getPersona: ZIO[Any, Nothing, zio.aws.nimble.model.StudioPersona] =
      ZIO.succeed(persona)
    def getPrincipalId: ZIO[Any, Nothing, String] = ZIO.succeed(principalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.NewStudioMember
  ) extends zio.aws.nimble.model.NewStudioMember.ReadOnly {
    override val persona: zio.aws.nimble.model.StudioPersona =
      zio.aws.nimble.model.StudioPersona.wrap(impl.persona())
    override val principalId: String = impl.principalId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.NewStudioMember
  ): zio.aws.nimble.model.NewStudioMember.ReadOnly = new Wrapper(impl)
}
