package zio.aws.nimble.model
import java.lang.Integer
import zio.aws.nimble.model.primitives.{
  StreamingImageId,
  StreamConfigurationMaxStoppedSessionLengthInMinutes,
  StreamConfigurationMaxSessionLengthInMinutes
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StreamConfiguration(
    clipboardMode: zio.aws.nimble.model.StreamingClipboardMode,
    ec2InstanceTypes: Iterable[zio.aws.nimble.model.StreamingInstanceType],
    maxSessionLengthInMinutes: Option[
      StreamConfigurationMaxSessionLengthInMinutes
    ] = None,
    maxStoppedSessionLengthInMinutes: Option[
      StreamConfigurationMaxStoppedSessionLengthInMinutes
    ] = None,
    sessionStorage: Option[
      zio.aws.nimble.model.StreamConfigurationSessionStorage
    ] = None,
    streamingImageIds: Iterable[StreamingImageId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StreamConfiguration = {
    import StreamConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StreamConfiguration
      .builder()
      .clipboardMode(clipboardMode.unwrap)
      .ec2InstanceTypesWithStrings(ec2InstanceTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        maxSessionLengthInMinutes.map(value =>
          StreamConfigurationMaxSessionLengthInMinutes.unwrap(value): Integer
        )
      )(_.maxSessionLengthInMinutes)
      .optionallyWith(
        maxStoppedSessionLengthInMinutes.map(value =>
          StreamConfigurationMaxStoppedSessionLengthInMinutes.unwrap(
            value
          ): Integer
        )
      )(_.maxStoppedSessionLengthInMinutes)
      .optionallyWith(sessionStorage.map(value => value.buildAwsValue()))(
        _.sessionStorage
      )
      .streamingImageIds(streamingImageIds.map { item =>
        StreamingImageId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StreamConfiguration.ReadOnly =
    zio.aws.nimble.model.StreamConfiguration.wrap(buildAwsValue())
}
object StreamConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StreamConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StreamConfiguration =
      zio.aws.nimble.model.StreamConfiguration(
        clipboardMode,
        ec2InstanceTypes,
        maxSessionLengthInMinutes.map(value => value),
        maxStoppedSessionLengthInMinutes.map(value => value),
        sessionStorage.map(value => value.asEditable),
        streamingImageIds
      )
    def clipboardMode: zio.aws.nimble.model.StreamingClipboardMode
    def ec2InstanceTypes: List[zio.aws.nimble.model.StreamingInstanceType]
    def maxSessionLengthInMinutes
        : Option[StreamConfigurationMaxSessionLengthInMinutes]
    def maxStoppedSessionLengthInMinutes
        : Option[StreamConfigurationMaxStoppedSessionLengthInMinutes]
    def sessionStorage: Option[
      zio.aws.nimble.model.StreamConfigurationSessionStorage.ReadOnly
    ]
    def streamingImageIds: List[StreamingImageId]
    def getClipboardMode
        : ZIO[Any, Nothing, zio.aws.nimble.model.StreamingClipboardMode] =
      ZIO.succeed(clipboardMode)
    def getEc2InstanceTypes
        : ZIO[Any, Nothing, List[zio.aws.nimble.model.StreamingInstanceType]] =
      ZIO.succeed(ec2InstanceTypes)
    def getMaxSessionLengthInMinutes
        : ZIO[Any, AwsError, StreamConfigurationMaxSessionLengthInMinutes] =
      AwsError.unwrapOptionField(
        "maxSessionLengthInMinutes",
        maxSessionLengthInMinutes
      )
    def getMaxStoppedSessionLengthInMinutes: ZIO[
      Any,
      AwsError,
      StreamConfigurationMaxStoppedSessionLengthInMinutes
    ] = AwsError.unwrapOptionField(
      "maxStoppedSessionLengthInMinutes",
      maxStoppedSessionLengthInMinutes
    )
    def getSessionStorage: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamConfigurationSessionStorage.ReadOnly
    ] = AwsError.unwrapOptionField("sessionStorage", sessionStorage)
    def getStreamingImageIds: ZIO[Any, Nothing, List[StreamingImageId]] =
      ZIO.succeed(streamingImageIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StreamConfiguration
  ) extends zio.aws.nimble.model.StreamConfiguration.ReadOnly {
    override val clipboardMode: zio.aws.nimble.model.StreamingClipboardMode =
      zio.aws.nimble.model.StreamingClipboardMode.wrap(impl.clipboardMode())
    override val ec2InstanceTypes
        : List[zio.aws.nimble.model.StreamingInstanceType] = impl
      .ec2InstanceTypes()
      .asScala
      .map { item =>
        zio.aws.nimble.model.StreamingInstanceType.wrap(item)
      }
      .toList
    override val maxSessionLengthInMinutes
        : Option[StreamConfigurationMaxSessionLengthInMinutes] = scala
      .Option(impl.maxSessionLengthInMinutes())
      .map(value =>
        zio.aws.nimble.model.primitives
          .StreamConfigurationMaxSessionLengthInMinutes(value)
      )
    override val maxStoppedSessionLengthInMinutes
        : Option[StreamConfigurationMaxStoppedSessionLengthInMinutes] = scala
      .Option(impl.maxStoppedSessionLengthInMinutes())
      .map(value =>
        zio.aws.nimble.model.primitives
          .StreamConfigurationMaxStoppedSessionLengthInMinutes(value)
      )
    override val sessionStorage: Option[
      zio.aws.nimble.model.StreamConfigurationSessionStorage.ReadOnly
    ] = scala
      .Option(impl.sessionStorage())
      .map(value =>
        zio.aws.nimble.model.StreamConfigurationSessionStorage.wrap(value)
      )
    override val streamingImageIds: List[StreamingImageId] = impl
      .streamingImageIds()
      .asScala
      .map { item =>
        zio.aws.nimble.model.primitives.StreamingImageId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StreamConfiguration
  ): zio.aws.nimble.model.StreamConfiguration.ReadOnly = new Wrapper(impl)
}
