package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait StreamingClipboardMode {
  def unwrap
      : software.amazon.awssdk.services.nimble.model.StreamingClipboardMode
}
object StreamingClipboardMode {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StreamingClipboardMode
  ): zio.aws.nimble.model.StreamingClipboardMode = value match {
    case software.amazon.awssdk.services.nimble.model.StreamingClipboardMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StreamingClipboardMode.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingClipboardMode.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StreamingClipboardMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingClipboardMode =
      software.amazon.awssdk.services.nimble.model.StreamingClipboardMode.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.nimble.model.StreamingClipboardMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingClipboardMode =
      software.amazon.awssdk.services.nimble.model.StreamingClipboardMode.ENABLED
  }
  case object DISABLED extends zio.aws.nimble.model.StreamingClipboardMode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingClipboardMode =
      software.amazon.awssdk.services.nimble.model.StreamingClipboardMode.DISABLED
  }
}
