package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.StreamingImageEncryptionConfigurationKeyArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StreamingImageEncryptionConfiguration(
    keyArn: Option[StreamingImageEncryptionConfigurationKeyArn] = None,
    keyType: zio.aws.nimble.model.StreamingImageEncryptionConfigurationKeyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfiguration = {
    import StreamingImageEncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfiguration
      .builder()
      .optionallyWith(
        keyArn.map(value =>
          StreamingImageEncryptionConfigurationKeyArn.unwrap(
            value
          ): java.lang.String
        )
      )(_.keyArn)
      .keyType(keyType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.StreamingImageEncryptionConfiguration.ReadOnly =
    zio.aws.nimble.model.StreamingImageEncryptionConfiguration
      .wrap(buildAwsValue())
}
object StreamingImageEncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StreamingImageEncryptionConfiguration =
      zio.aws.nimble.model.StreamingImageEncryptionConfiguration(
        keyArn.map(value => value),
        keyType
      )
    def keyArn: Option[StreamingImageEncryptionConfigurationKeyArn]
    def keyType
        : zio.aws.nimble.model.StreamingImageEncryptionConfigurationKeyType
    def getKeyArn
        : ZIO[Any, AwsError, StreamingImageEncryptionConfigurationKeyArn] =
      AwsError.unwrapOptionField("keyArn", keyArn)
    def getKeyType: ZIO[
      Any,
      Nothing,
      zio.aws.nimble.model.StreamingImageEncryptionConfigurationKeyType
    ] = ZIO.succeed(keyType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfiguration
  ) extends zio.aws.nimble.model.StreamingImageEncryptionConfiguration.ReadOnly {
    override val keyArn: Option[StreamingImageEncryptionConfigurationKeyArn] =
      scala
        .Option(impl.keyArn())
        .map(value =>
          zio.aws.nimble.model.primitives
            .StreamingImageEncryptionConfigurationKeyArn(value)
        )
    override val keyType
        : zio.aws.nimble.model.StreamingImageEncryptionConfigurationKeyType =
      zio.aws.nimble.model.StreamingImageEncryptionConfigurationKeyType
        .wrap(impl.keyType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfiguration
  ): zio.aws.nimble.model.StreamingImageEncryptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
