package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait StreamingImageEncryptionConfigurationKeyType {
  def unwrap: software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfigurationKeyType
}
object StreamingImageEncryptionConfigurationKeyType {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfigurationKeyType
  ): zio.aws.nimble.model.StreamingImageEncryptionConfigurationKeyType =
    value match {
      case software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfigurationKeyType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfigurationKeyType.CUSTOMER_MANAGED_KEY =>
        val r = CUSTOMER_MANAGED_KEY
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StreamingImageEncryptionConfigurationKeyType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfigurationKeyType =
      software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfigurationKeyType.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOMER_MANAGED_KEY
      extends zio.aws.nimble.model.StreamingImageEncryptionConfigurationKeyType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfigurationKeyType =
      software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfigurationKeyType.CUSTOMER_MANAGED_KEY
  }
}
