package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait StreamingImageState {
  def unwrap: software.amazon.awssdk.services.nimble.model.StreamingImageState
}
object StreamingImageState {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StreamingImageState
  ): zio.aws.nimble.model.StreamingImageState = value match {
    case software.amazon.awssdk.services.nimble.model.StreamingImageState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageState.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageState.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageState.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageState.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageState.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageState.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StreamingImageState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageState =
      software.amazon.awssdk.services.nimble.model.StreamingImageState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingImageState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageState =
      software.amazon.awssdk.services.nimble.model.StreamingImageState.CREATE_IN_PROGRESS
  }
  case object READY extends zio.aws.nimble.model.StreamingImageState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageState =
      software.amazon.awssdk.services.nimble.model.StreamingImageState.READY
  }
  case object DELETE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingImageState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageState =
      software.amazon.awssdk.services.nimble.model.StreamingImageState.DELETE_IN_PROGRESS
  }
  case object DELETED extends zio.aws.nimble.model.StreamingImageState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageState =
      software.amazon.awssdk.services.nimble.model.StreamingImageState.DELETED
  }
  case object UPDATE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingImageState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageState =
      software.amazon.awssdk.services.nimble.model.StreamingImageState.UPDATE_IN_PROGRESS
  }
  case object UPDATE_FAILED extends zio.aws.nimble.model.StreamingImageState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageState =
      software.amazon.awssdk.services.nimble.model.StreamingImageState.UPDATE_FAILED
  }
  case object CREATE_FAILED extends zio.aws.nimble.model.StreamingImageState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageState =
      software.amazon.awssdk.services.nimble.model.StreamingImageState.CREATE_FAILED
  }
  case object DELETE_FAILED extends zio.aws.nimble.model.StreamingImageState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageState =
      software.amazon.awssdk.services.nimble.model.StreamingImageState.DELETE_FAILED
  }
}
