package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait StreamingInstanceType {
  def unwrap: software.amazon.awssdk.services.nimble.model.StreamingInstanceType
}
object StreamingInstanceType {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StreamingInstanceType
  ): zio.aws.nimble.model.StreamingInstanceType = value match {
    case software.amazon.awssdk.services.nimble.model.StreamingInstanceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StreamingInstanceType.G4_DN_XLARGE =>
      val r = `g4dn.xlarge`
      r
    case software.amazon.awssdk.services.nimble.model.StreamingInstanceType.G4_DN_2_XLARGE =>
      val r = `g4dn.2xlarge`
      r
    case software.amazon.awssdk.services.nimble.model.StreamingInstanceType.G4_DN_4_XLARGE =>
      val r = `g4dn.4xlarge`
      r
    case software.amazon.awssdk.services.nimble.model.StreamingInstanceType.G4_DN_8_XLARGE =>
      val r = `g4dn.8xlarge`
      r
    case software.amazon.awssdk.services.nimble.model.StreamingInstanceType.G4_DN_12_XLARGE =>
      val r = `g4dn.12xlarge`
      r
    case software.amazon.awssdk.services.nimble.model.StreamingInstanceType.G4_DN_16_XLARGE =>
      val r = `g4dn.16xlarge`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StreamingInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingInstanceType =
      software.amazon.awssdk.services.nimble.model.StreamingInstanceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `g4dn.xlarge` extends zio.aws.nimble.model.StreamingInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingInstanceType =
      software.amazon.awssdk.services.nimble.model.StreamingInstanceType.G4_DN_XLARGE
  }
  case object `g4dn.2xlarge`
      extends zio.aws.nimble.model.StreamingInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingInstanceType =
      software.amazon.awssdk.services.nimble.model.StreamingInstanceType.G4_DN_2_XLARGE
  }
  case object `g4dn.4xlarge`
      extends zio.aws.nimble.model.StreamingInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingInstanceType =
      software.amazon.awssdk.services.nimble.model.StreamingInstanceType.G4_DN_4_XLARGE
  }
  case object `g4dn.8xlarge`
      extends zio.aws.nimble.model.StreamingInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingInstanceType =
      software.amazon.awssdk.services.nimble.model.StreamingInstanceType.G4_DN_8_XLARGE
  }
  case object `g4dn.12xlarge`
      extends zio.aws.nimble.model.StreamingInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingInstanceType =
      software.amazon.awssdk.services.nimble.model.StreamingInstanceType.G4_DN_12_XLARGE
  }
  case object `g4dn.16xlarge`
      extends zio.aws.nimble.model.StreamingInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingInstanceType =
      software.amazon.awssdk.services.nimble.model.StreamingInstanceType.G4_DN_16_XLARGE
  }
}
