package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StreamingImageId,
  StreamingSessionId,
  Timestamp
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class StreamingSession(
    arn: Option[String] = None,
    createdAt: Option[Timestamp] = None,
    createdBy: Option[String] = None,
    ec2InstanceType: Option[String] = None,
    launchProfileId: Option[String] = None,
    ownedBy: Option[String] = None,
    sessionId: Option[StreamingSessionId] = None,
    startedAt: Option[Timestamp] = None,
    startedBy: Option[String] = None,
    state: Option[zio.aws.nimble.model.StreamingSessionState] = None,
    statusCode: Option[zio.aws.nimble.model.StreamingSessionStatusCode] = None,
    statusMessage: Option[String] = None,
    stopAt: Option[Timestamp] = None,
    stoppedAt: Option[Timestamp] = None,
    stoppedBy: Option[String] = None,
    streamingImageId: Option[StreamingImageId] = None,
    tags: Option[Map[String, String]] = None,
    terminateAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    updatedBy: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StreamingSession = {
    import StreamingSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StreamingSession
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(ec2InstanceType.map(value => value: java.lang.String))(
        _.ec2InstanceType
      )
      .optionallyWith(launchProfileId.map(value => value: java.lang.String))(
        _.launchProfileId
      )
      .optionallyWith(ownedBy.map(value => value: java.lang.String))(_.ownedBy)
      .optionallyWith(
        sessionId.map(value =>
          StreamingSessionId.unwrap(value): java.lang.String
        )
      )(_.sessionId)
      .optionallyWith(startedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(startedBy.map(value => value: java.lang.String))(
        _.startedBy
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(stopAt.map(value => Timestamp.unwrap(value): Instant))(
        _.stopAt
      )
      .optionallyWith(stoppedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.stoppedAt
      )
      .optionallyWith(stoppedBy.map(value => value: java.lang.String))(
        _.stoppedBy
      )
      .optionallyWith(
        streamingImageId.map(value =>
          StreamingImageId.unwrap(value): java.lang.String
        )
      )(_.streamingImageId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        terminateAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.terminateAt)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(updatedBy.map(value => value: java.lang.String))(
        _.updatedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StreamingSession.ReadOnly =
    zio.aws.nimble.model.StreamingSession.wrap(buildAwsValue())
}
object StreamingSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StreamingSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StreamingSession =
      zio.aws.nimble.model.StreamingSession(
        arn.map(value => value),
        createdAt.map(value => value),
        createdBy.map(value => value),
        ec2InstanceType.map(value => value),
        launchProfileId.map(value => value),
        ownedBy.map(value => value),
        sessionId.map(value => value),
        startedAt.map(value => value),
        startedBy.map(value => value),
        state.map(value => value),
        statusCode.map(value => value),
        statusMessage.map(value => value),
        stopAt.map(value => value),
        stoppedAt.map(value => value),
        stoppedBy.map(value => value),
        streamingImageId.map(value => value),
        tags.map(value => value),
        terminateAt.map(value => value),
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def arn: Option[String]
    def createdAt: Option[Timestamp]
    def createdBy: Option[String]
    def ec2InstanceType: Option[String]
    def launchProfileId: Option[String]
    def ownedBy: Option[String]
    def sessionId: Option[StreamingSessionId]
    def startedAt: Option[Timestamp]
    def startedBy: Option[String]
    def state: Option[zio.aws.nimble.model.StreamingSessionState]
    def statusCode: Option[zio.aws.nimble.model.StreamingSessionStatusCode]
    def statusMessage: Option[String]
    def stopAt: Option[Timestamp]
    def stoppedAt: Option[Timestamp]
    def stoppedBy: Option[String]
    def streamingImageId: Option[StreamingImageId]
    def tags: Option[Map[String, String]]
    def terminateAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def updatedBy: Option[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getEc2InstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2InstanceType", ec2InstanceType)
    def getLaunchProfileId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchProfileId", launchProfileId)
    def getOwnedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownedBy", ownedBy)
    def getSessionId: ZIO[Any, AwsError, StreamingSessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getStartedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getState
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingSessionState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusCode
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingSessionStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStopAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stopAt", stopAt)
    def getStoppedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stoppedAt", stoppedAt)
    def getStoppedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stoppedBy", stoppedBy)
    def getStreamingImageId: ZIO[Any, AwsError, StreamingImageId] =
      AwsError.unwrapOptionField("streamingImageId", streamingImageId)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTerminateAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("terminateAt", terminateAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StreamingSession
  ) extends zio.aws.nimble.model.StreamingSession.ReadOnly {
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val createdBy: Option[String] =
      scala.Option(impl.createdBy()).map(value => value: String)
    override val ec2InstanceType: Option[String] =
      scala.Option(impl.ec2InstanceType()).map(value => value: String)
    override val launchProfileId: Option[String] =
      scala.Option(impl.launchProfileId()).map(value => value: String)
    override val ownedBy: Option[String] =
      scala.Option(impl.ownedBy()).map(value => value: String)
    override val sessionId: Option[StreamingSessionId] = scala
      .Option(impl.sessionId())
      .map(value => zio.aws.nimble.model.primitives.StreamingSessionId(value))
    override val startedAt: Option[Timestamp] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val startedBy: Option[String] =
      scala.Option(impl.startedBy()).map(value => value: String)
    override val state: Option[zio.aws.nimble.model.StreamingSessionState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.nimble.model.StreamingSessionState.wrap(value))
    override val statusCode
        : Option[zio.aws.nimble.model.StreamingSessionStatusCode] = scala
      .Option(impl.statusCode())
      .map(value => zio.aws.nimble.model.StreamingSessionStatusCode.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val stopAt: Option[Timestamp] = scala
      .Option(impl.stopAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val stoppedAt: Option[Timestamp] = scala
      .Option(impl.stoppedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val stoppedBy: Option[String] =
      scala.Option(impl.stoppedBy()).map(value => value: String)
    override val streamingImageId: Option[StreamingImageId] = scala
      .Option(impl.streamingImageId())
      .map(value => zio.aws.nimble.model.primitives.StreamingImageId(value))
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val terminateAt: Option[Timestamp] = scala
      .Option(impl.terminateAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val updatedBy: Option[String] =
      scala.Option(impl.updatedBy()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StreamingSession
  ): zio.aws.nimble.model.StreamingSession.ReadOnly = new Wrapper(impl)
}
