package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait StreamingSessionStatusCode {
  def unwrap
      : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode
}
object StreamingSessionStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode
  ): zio.aws.nimble.model.StreamingSessionStatusCode = value match {
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_READY =>
      val r = STREAMING_SESSION_READY
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_DELETED =>
      val r = STREAMING_SESSION_DELETED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_CREATE_IN_PROGRESS =>
      val r = STREAMING_SESSION_CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_DELETE_IN_PROGRESS =>
      val r = STREAMING_SESSION_DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.INSUFFICIENT_CAPACITY =>
      val r = INSUFFICIENT_CAPACITY
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.ACTIVE_DIRECTORY_DOMAIN_JOIN_ERROR =>
      val r = ACTIVE_DIRECTORY_DOMAIN_JOIN_ERROR
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.NETWORK_CONNECTION_ERROR =>
      val r = NETWORK_CONNECTION_ERROR
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.INITIALIZATION_SCRIPT_ERROR =>
      val r = INITIALIZATION_SCRIPT_ERROR
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.DECRYPT_STREAMING_IMAGE_ERROR =>
      val r = DECRYPT_STREAMING_IMAGE_ERROR
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.NETWORK_INTERFACE_ERROR =>
      val r = NETWORK_INTERFACE_ERROR
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_STOPPED =>
      val r = STREAMING_SESSION_STOPPED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_STARTED =>
      val r = STREAMING_SESSION_STARTED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_STOP_IN_PROGRESS =>
      val r = STREAMING_SESSION_STOP_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_START_IN_PROGRESS =>
      val r = STREAMING_SESSION_START_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.AMI_VALIDATION_ERROR =>
      val r = AMI_VALIDATION_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object STREAMING_SESSION_READY
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_READY
  }
  case object STREAMING_SESSION_DELETED
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_DELETED
  }
  case object STREAMING_SESSION_CREATE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_CREATE_IN_PROGRESS
  }
  case object STREAMING_SESSION_DELETE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_DELETE_IN_PROGRESS
  }
  case object INTERNAL_ERROR
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.INTERNAL_ERROR
  }
  case object INSUFFICIENT_CAPACITY
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.INSUFFICIENT_CAPACITY
  }
  case object ACTIVE_DIRECTORY_DOMAIN_JOIN_ERROR
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.ACTIVE_DIRECTORY_DOMAIN_JOIN_ERROR
  }
  case object NETWORK_CONNECTION_ERROR
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.NETWORK_CONNECTION_ERROR
  }
  case object INITIALIZATION_SCRIPT_ERROR
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.INITIALIZATION_SCRIPT_ERROR
  }
  case object DECRYPT_STREAMING_IMAGE_ERROR
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.DECRYPT_STREAMING_IMAGE_ERROR
  }
  case object NETWORK_INTERFACE_ERROR
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.NETWORK_INTERFACE_ERROR
  }
  case object STREAMING_SESSION_STOPPED
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_STOPPED
  }
  case object STREAMING_SESSION_STARTED
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_STARTED
  }
  case object STREAMING_SESSION_STOP_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_STOP_IN_PROGRESS
  }
  case object STREAMING_SESSION_START_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.STREAMING_SESSION_START_IN_PROGRESS
  }
  case object AMI_VALIDATION_ERROR
      extends zio.aws.nimble.model.StreamingSessionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStatusCode.AMI_VALIDATION_ERROR
  }
}
