package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  SyntheticStreamingSessionStreamString,
  Timestamp
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class StreamingSessionStream(
    createdAt: Option[Timestamp] = None,
    createdBy: Option[String] = None,
    expiresAt: Option[Timestamp] = None,
    ownedBy: Option[String] = None,
    state: Option[zio.aws.nimble.model.StreamingSessionStreamState] = None,
    statusCode: Option[zio.aws.nimble.model.StreamingSessionStreamStatusCode] =
      None,
    streamId: Option[String] = None,
    url: Option[SyntheticStreamingSessionStreamString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StreamingSessionStream = {
    import StreamingSessionStream.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StreamingSessionStream
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(expiresAt.map(value => Timestamp.unwrap(value): Instant))(
        _.expiresAt
      )
      .optionallyWith(ownedBy.map(value => value: java.lang.String))(_.ownedBy)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(streamId.map(value => value: java.lang.String))(
        _.streamId
      )
      .optionallyWith(
        url.map(value =>
          SyntheticStreamingSessionStreamString.unwrap(value): java.lang.String
        )
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StreamingSessionStream.ReadOnly =
    zio.aws.nimble.model.StreamingSessionStream.wrap(buildAwsValue())
}
object StreamingSessionStream {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StreamingSessionStream
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StreamingSessionStream =
      zio.aws.nimble.model.StreamingSessionStream(
        createdAt.map(value => value),
        createdBy.map(value => value),
        expiresAt.map(value => value),
        ownedBy.map(value => value),
        state.map(value => value),
        statusCode.map(value => value),
        streamId.map(value => value),
        url.map(value => value)
      )
    def createdAt: Option[Timestamp]
    def createdBy: Option[String]
    def expiresAt: Option[Timestamp]
    def ownedBy: Option[String]
    def state: Option[zio.aws.nimble.model.StreamingSessionStreamState]
    def statusCode
        : Option[zio.aws.nimble.model.StreamingSessionStreamStatusCode]
    def streamId: Option[String]
    def url: Option[SyntheticStreamingSessionStreamString]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getExpiresAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expiresAt", expiresAt)
    def getOwnedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownedBy", ownedBy)
    def getState
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingSessionStreamState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusCode: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamingSessionStreamStatusCode
    ] = AwsError.unwrapOptionField("statusCode", statusCode)
    def getStreamId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamId", streamId)
    def getUrl: ZIO[Any, AwsError, SyntheticStreamingSessionStreamString] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StreamingSessionStream
  ) extends zio.aws.nimble.model.StreamingSessionStream.ReadOnly {
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val createdBy: Option[String] =
      scala.Option(impl.createdBy()).map(value => value: String)
    override val expiresAt: Option[Timestamp] = scala
      .Option(impl.expiresAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val ownedBy: Option[String] =
      scala.Option(impl.ownedBy()).map(value => value: String)
    override val state
        : Option[zio.aws.nimble.model.StreamingSessionStreamState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.nimble.model.StreamingSessionStreamState.wrap(value)
      )
    override val statusCode
        : Option[zio.aws.nimble.model.StreamingSessionStreamStatusCode] = scala
      .Option(impl.statusCode())
      .map(value =>
        zio.aws.nimble.model.StreamingSessionStreamStatusCode.wrap(value)
      )
    override val streamId: Option[String] =
      scala.Option(impl.streamId()).map(value => value: String)
    override val url: Option[SyntheticStreamingSessionStreamString] = scala
      .Option(impl.url())
      .map(value =>
        zio.aws.nimble.model.primitives
          .SyntheticStreamingSessionStreamString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StreamingSessionStream
  ): zio.aws.nimble.model.StreamingSessionStream.ReadOnly = new Wrapper(impl)
}
