package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait StreamingSessionStreamStatusCode {
  def unwrap: software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode
}
object StreamingSessionStreamStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode
  ): zio.aws.nimble.model.StreamingSessionStreamStatusCode = value match {
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.STREAM_CREATE_IN_PROGRESS =>
      val r = STREAM_CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.STREAM_READY =>
      val r = STREAM_READY
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.STREAM_DELETE_IN_PROGRESS =>
      val r = STREAM_DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.STREAM_DELETED =>
      val r = STREAM_DELETED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.NETWORK_CONNECTION_ERROR =>
      val r = NETWORK_CONNECTION_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StreamingSessionStreamStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object STREAM_CREATE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingSessionStreamStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.STREAM_CREATE_IN_PROGRESS
  }
  case object STREAM_READY
      extends zio.aws.nimble.model.StreamingSessionStreamStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.STREAM_READY
  }
  case object STREAM_DELETE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingSessionStreamStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.STREAM_DELETE_IN_PROGRESS
  }
  case object STREAM_DELETED
      extends zio.aws.nimble.model.StreamingSessionStreamStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.STREAM_DELETED
  }
  case object INTERNAL_ERROR
      extends zio.aws.nimble.model.StreamingSessionStreamStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.INTERNAL_ERROR
  }
  case object NETWORK_CONNECTION_ERROR
      extends zio.aws.nimble.model.StreamingSessionStreamStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingSessionStreamStatusCode.NETWORK_CONNECTION_ERROR
  }
}
