package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StudioComponentConfiguration(
    activeDirectoryConfiguration: Option[
      zio.aws.nimble.model.ActiveDirectoryConfiguration
    ] = None,
    computeFarmConfiguration: Option[
      zio.aws.nimble.model.ComputeFarmConfiguration
    ] = None,
    licenseServiceConfiguration: Option[
      zio.aws.nimble.model.LicenseServiceConfiguration
    ] = None,
    sharedFileSystemConfiguration: Option[
      zio.aws.nimble.model.SharedFileSystemConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StudioComponentConfiguration = {
    import StudioComponentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StudioComponentConfiguration
      .builder()
      .optionallyWith(
        activeDirectoryConfiguration.map(value => value.buildAwsValue())
      )(_.activeDirectoryConfiguration)
      .optionallyWith(
        computeFarmConfiguration.map(value => value.buildAwsValue())
      )(_.computeFarmConfiguration)
      .optionallyWith(
        licenseServiceConfiguration.map(value => value.buildAwsValue())
      )(_.licenseServiceConfiguration)
      .optionallyWith(
        sharedFileSystemConfiguration.map(value => value.buildAwsValue())
      )(_.sharedFileSystemConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly =
    zio.aws.nimble.model.StudioComponentConfiguration.wrap(buildAwsValue())
}
object StudioComponentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StudioComponentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StudioComponentConfiguration =
      zio.aws.nimble.model.StudioComponentConfiguration(
        activeDirectoryConfiguration.map(value => value.asEditable),
        computeFarmConfiguration.map(value => value.asEditable),
        licenseServiceConfiguration.map(value => value.asEditable),
        sharedFileSystemConfiguration.map(value => value.asEditable)
      )
    def activeDirectoryConfiguration
        : Option[zio.aws.nimble.model.ActiveDirectoryConfiguration.ReadOnly]
    def computeFarmConfiguration
        : Option[zio.aws.nimble.model.ComputeFarmConfiguration.ReadOnly]
    def licenseServiceConfiguration
        : Option[zio.aws.nimble.model.LicenseServiceConfiguration.ReadOnly]
    def sharedFileSystemConfiguration
        : Option[zio.aws.nimble.model.SharedFileSystemConfiguration.ReadOnly]
    def getActiveDirectoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.ActiveDirectoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activeDirectoryConfiguration",
      activeDirectoryConfiguration
    )
    def getComputeFarmConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.ComputeFarmConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "computeFarmConfiguration",
      computeFarmConfiguration
    )
    def getLicenseServiceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.LicenseServiceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "licenseServiceConfiguration",
      licenseServiceConfiguration
    )
    def getSharedFileSystemConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.SharedFileSystemConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sharedFileSystemConfiguration",
      sharedFileSystemConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponentConfiguration
  ) extends zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly {
    override val activeDirectoryConfiguration
        : Option[zio.aws.nimble.model.ActiveDirectoryConfiguration.ReadOnly] =
      scala
        .Option(impl.activeDirectoryConfiguration())
        .map(value =>
          zio.aws.nimble.model.ActiveDirectoryConfiguration.wrap(value)
        )
    override val computeFarmConfiguration
        : Option[zio.aws.nimble.model.ComputeFarmConfiguration.ReadOnly] = scala
      .Option(impl.computeFarmConfiguration())
      .map(value => zio.aws.nimble.model.ComputeFarmConfiguration.wrap(value))
    override val licenseServiceConfiguration
        : Option[zio.aws.nimble.model.LicenseServiceConfiguration.ReadOnly] =
      scala
        .Option(impl.licenseServiceConfiguration())
        .map(value =>
          zio.aws.nimble.model.LicenseServiceConfiguration.wrap(value)
        )
    override val sharedFileSystemConfiguration
        : Option[zio.aws.nimble.model.SharedFileSystemConfiguration.ReadOnly] =
      scala
        .Option(impl.sharedFileSystemConfiguration())
        .map(value =>
          zio.aws.nimble.model.SharedFileSystemConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponentConfiguration
  ): zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
