package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StudioComponentInitializationScriptContent,
  LaunchProfileProtocolVersion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StudioComponentInitializationScript(
    launchProfileProtocolVersion: Option[LaunchProfileProtocolVersion] = None,
    platform: Option[zio.aws.nimble.model.LaunchProfilePlatform] = None,
    runContext: Option[
      zio.aws.nimble.model.StudioComponentInitializationScriptRunContext
    ] = None,
    script: Option[StudioComponentInitializationScriptContent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScript = {
    import StudioComponentInitializationScript.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScript
      .builder()
      .optionallyWith(
        launchProfileProtocolVersion.map(value =>
          LaunchProfileProtocolVersion.unwrap(value): java.lang.String
        )
      )(_.launchProfileProtocolVersion)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(runContext.map(value => value.unwrap))(_.runContext)
      .optionallyWith(
        script.map(value =>
          StudioComponentInitializationScriptContent.unwrap(
            value
          ): java.lang.String
        )
      )(_.script)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly =
    zio.aws.nimble.model.StudioComponentInitializationScript
      .wrap(buildAwsValue())
}
object StudioComponentInitializationScript {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScript
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StudioComponentInitializationScript =
      zio.aws.nimble.model.StudioComponentInitializationScript(
        launchProfileProtocolVersion.map(value => value),
        platform.map(value => value),
        runContext.map(value => value),
        script.map(value => value)
      )
    def launchProfileProtocolVersion: Option[LaunchProfileProtocolVersion]
    def platform: Option[zio.aws.nimble.model.LaunchProfilePlatform]
    def runContext: Option[
      zio.aws.nimble.model.StudioComponentInitializationScriptRunContext
    ]
    def script: Option[StudioComponentInitializationScriptContent]
    def getLaunchProfileProtocolVersion
        : ZIO[Any, AwsError, LaunchProfileProtocolVersion] =
      AwsError.unwrapOptionField(
        "launchProfileProtocolVersion",
        launchProfileProtocolVersion
      )
    def getPlatform
        : ZIO[Any, AwsError, zio.aws.nimble.model.LaunchProfilePlatform] =
      AwsError.unwrapOptionField("platform", platform)
    def getRunContext: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StudioComponentInitializationScriptRunContext
    ] = AwsError.unwrapOptionField("runContext", runContext)
    def getScript
        : ZIO[Any, AwsError, StudioComponentInitializationScriptContent] =
      AwsError.unwrapOptionField("script", script)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScript
  ) extends zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly {
    override val launchProfileProtocolVersion
        : Option[LaunchProfileProtocolVersion] = scala
      .Option(impl.launchProfileProtocolVersion())
      .map(value =>
        zio.aws.nimble.model.primitives.LaunchProfileProtocolVersion(value)
      )
    override val platform: Option[zio.aws.nimble.model.LaunchProfilePlatform] =
      scala
        .Option(impl.platform())
        .map(value => zio.aws.nimble.model.LaunchProfilePlatform.wrap(value))
    override val runContext: Option[
      zio.aws.nimble.model.StudioComponentInitializationScriptRunContext
    ] = scala
      .Option(impl.runContext())
      .map(value =>
        zio.aws.nimble.model.StudioComponentInitializationScriptRunContext
          .wrap(value)
      )
    override val script: Option[StudioComponentInitializationScriptContent] =
      scala
        .Option(impl.script())
        .map(value =>
          zio.aws.nimble.model.primitives
            .StudioComponentInitializationScriptContent(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScript
  ): zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly =
    new Wrapper(impl)
}
