package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait StudioComponentInitializationScriptRunContext {
  def unwrap: software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptRunContext
}
object StudioComponentInitializationScriptRunContext {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptRunContext
  ): zio.aws.nimble.model.StudioComponentInitializationScriptRunContext =
    value match {
      case software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptRunContext.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptRunContext.SYSTEM_INITIALIZATION =>
        val r = SYSTEM_INITIALIZATION
        r
      case software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptRunContext.USER_INITIALIZATION =>
        val r = USER_INITIALIZATION
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StudioComponentInitializationScriptRunContext {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptRunContext =
      software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptRunContext.UNKNOWN_TO_SDK_VERSION
  }
  case object SYSTEM_INITIALIZATION
      extends zio.aws.nimble.model.StudioComponentInitializationScriptRunContext {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptRunContext =
      software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptRunContext.SYSTEM_INITIALIZATION
  }
  case object USER_INITIALIZATION
      extends zio.aws.nimble.model.StudioComponentInitializationScriptRunContext {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptRunContext =
      software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptRunContext.USER_INITIALIZATION
  }
}
