package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait StudioComponentSubtype {
  def unwrap
      : software.amazon.awssdk.services.nimble.model.StudioComponentSubtype
}
object StudioComponentSubtype {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StudioComponentSubtype
  ): zio.aws.nimble.model.StudioComponentSubtype = value match {
    case software.amazon.awssdk.services.nimble.model.StudioComponentSubtype.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentSubtype.AWS_MANAGED_MICROSOFT_AD =>
      val r = AWS_MANAGED_MICROSOFT_AD
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentSubtype.AMAZON_FSX_FOR_WINDOWS =>
      val r = AMAZON_FSX_FOR_WINDOWS
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentSubtype.AMAZON_FSX_FOR_LUSTRE =>
      val r = AMAZON_FSX_FOR_LUSTRE
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentSubtype.CUSTOM =>
      val r = CUSTOM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StudioComponentSubtype {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentSubtype =
      software.amazon.awssdk.services.nimble.model.StudioComponentSubtype.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_MANAGED_MICROSOFT_AD
      extends zio.aws.nimble.model.StudioComponentSubtype {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentSubtype =
      software.amazon.awssdk.services.nimble.model.StudioComponentSubtype.AWS_MANAGED_MICROSOFT_AD
  }
  case object AMAZON_FSX_FOR_WINDOWS
      extends zio.aws.nimble.model.StudioComponentSubtype {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentSubtype =
      software.amazon.awssdk.services.nimble.model.StudioComponentSubtype.AMAZON_FSX_FOR_WINDOWS
  }
  case object AMAZON_FSX_FOR_LUSTRE
      extends zio.aws.nimble.model.StudioComponentSubtype {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentSubtype =
      software.amazon.awssdk.services.nimble.model.StudioComponentSubtype.AMAZON_FSX_FOR_LUSTRE
  }
  case object CUSTOM extends zio.aws.nimble.model.StudioComponentSubtype {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentSubtype =
      software.amazon.awssdk.services.nimble.model.StudioComponentSubtype.CUSTOM
  }
}
