package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StudioComponentId,
  StudioComponentName,
  StudioComponentDescription,
  Timestamp
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class StudioComponentSummary(
    createdAt: Option[Timestamp] = None,
    createdBy: Option[String] = None,
    description: Option[StudioComponentDescription] = None,
    name: Option[StudioComponentName] = None,
    studioComponentId: Option[StudioComponentId] = None,
    subtype: Option[zio.aws.nimble.model.StudioComponentSubtype] = None,
    `type`: Option[zio.aws.nimble.model.StudioComponentType] = None,
    updatedAt: Option[Timestamp] = None,
    updatedBy: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StudioComponentSummary = {
    import StudioComponentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StudioComponentSummary
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(
        description.map(value =>
          StudioComponentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        name.map(value => StudioComponentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        studioComponentId.map(value =>
          StudioComponentId.unwrap(value): java.lang.String
        )
      )(_.studioComponentId)
      .optionallyWith(subtype.map(value => value.unwrap))(_.subtype)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(updatedBy.map(value => value: java.lang.String))(
        _.updatedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StudioComponentSummary.ReadOnly =
    zio.aws.nimble.model.StudioComponentSummary.wrap(buildAwsValue())
}
object StudioComponentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StudioComponentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StudioComponentSummary =
      zio.aws.nimble.model.StudioComponentSummary(
        createdAt.map(value => value),
        createdBy.map(value => value),
        description.map(value => value),
        name.map(value => value),
        studioComponentId.map(value => value),
        subtype.map(value => value),
        `type`.map(value => value),
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def createdAt: Option[Timestamp]
    def createdBy: Option[String]
    def description: Option[StudioComponentDescription]
    def name: Option[StudioComponentName]
    def studioComponentId: Option[StudioComponentId]
    def subtype: Option[zio.aws.nimble.model.StudioComponentSubtype]
    def `type`: Option[zio.aws.nimble.model.StudioComponentType]
    def updatedAt: Option[Timestamp]
    def updatedBy: Option[String]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDescription: ZIO[Any, AwsError, StudioComponentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, StudioComponentName] =
      AwsError.unwrapOptionField("name", name)
    def getStudioComponentId: ZIO[Any, AwsError, StudioComponentId] =
      AwsError.unwrapOptionField("studioComponentId", studioComponentId)
    def getSubtype
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentSubtype] =
      AwsError.unwrapOptionField("subtype", subtype)
    def getType: ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponentSummary
  ) extends zio.aws.nimble.model.StudioComponentSummary.ReadOnly {
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val createdBy: Option[String] =
      scala.Option(impl.createdBy()).map(value => value: String)
    override val description: Option[StudioComponentDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.nimble.model.primitives.StudioComponentDescription(value)
      )
    override val name: Option[StudioComponentName] = scala
      .Option(impl.name())
      .map(value => zio.aws.nimble.model.primitives.StudioComponentName(value))
    override val studioComponentId: Option[StudioComponentId] = scala
      .Option(impl.studioComponentId())
      .map(value => zio.aws.nimble.model.primitives.StudioComponentId(value))
    override val subtype: Option[zio.aws.nimble.model.StudioComponentSubtype] =
      scala
        .Option(impl.subtype())
        .map(value => zio.aws.nimble.model.StudioComponentSubtype.wrap(value))
    override val `type`: Option[zio.aws.nimble.model.StudioComponentType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.nimble.model.StudioComponentType.wrap(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val updatedBy: Option[String] =
      scala.Option(impl.updatedBy()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponentSummary
  ): zio.aws.nimble.model.StudioComponentSummary.ReadOnly = new Wrapper(impl)
}
