package zio.aws.nimble.model
import scala.jdk.CollectionConverters.*
sealed trait StudioComponentType {
  def unwrap: software.amazon.awssdk.services.nimble.model.StudioComponentType
}
object StudioComponentType {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StudioComponentType
  ): zio.aws.nimble.model.StudioComponentType = value match {
    case software.amazon.awssdk.services.nimble.model.StudioComponentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentType.ACTIVE_DIRECTORY =>
      val r = ACTIVE_DIRECTORY
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentType.SHARED_FILE_SYSTEM =>
      val r = SHARED_FILE_SYSTEM
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentType.COMPUTE_FARM =>
      val r = COMPUTE_FARM
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentType.LICENSE_SERVICE =>
      val r = LICENSE_SERVICE
      r
    case software.amazon.awssdk.services.nimble.model.StudioComponentType.CUSTOM =>
      val r = CUSTOM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StudioComponentType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentType =
      software.amazon.awssdk.services.nimble.model.StudioComponentType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE_DIRECTORY
      extends zio.aws.nimble.model.StudioComponentType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentType =
      software.amazon.awssdk.services.nimble.model.StudioComponentType.ACTIVE_DIRECTORY
  }
  case object SHARED_FILE_SYSTEM
      extends zio.aws.nimble.model.StudioComponentType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentType =
      software.amazon.awssdk.services.nimble.model.StudioComponentType.SHARED_FILE_SYSTEM
  }
  case object COMPUTE_FARM extends zio.aws.nimble.model.StudioComponentType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentType =
      software.amazon.awssdk.services.nimble.model.StudioComponentType.COMPUTE_FARM
  }
  case object LICENSE_SERVICE extends zio.aws.nimble.model.StudioComponentType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentType =
      software.amazon.awssdk.services.nimble.model.StudioComponentType.LICENSE_SERVICE
  }
  case object CUSTOM extends zio.aws.nimble.model.StudioComponentType {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioComponentType =
      software.amazon.awssdk.services.nimble.model.StudioComponentType.CUSTOM
  }
}
