package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateLaunchProfileMemberResponse(
    member: Option[zio.aws.nimble.model.LaunchProfileMembership] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberResponse = {
    import UpdateLaunchProfileMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberResponse
      .builder()
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.UpdateLaunchProfileMemberResponse.ReadOnly =
    zio.aws.nimble.model.UpdateLaunchProfileMemberResponse.wrap(buildAwsValue())
}
object UpdateLaunchProfileMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.UpdateLaunchProfileMemberResponse =
      zio.aws.nimble.model.UpdateLaunchProfileMemberResponse(
        member.map(value => value.asEditable)
      )
    def member: Option[zio.aws.nimble.model.LaunchProfileMembership.ReadOnly]
    def getMember: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.LaunchProfileMembership.ReadOnly
    ] = AwsError.unwrapOptionField("member", member)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberResponse
  ) extends zio.aws.nimble.model.UpdateLaunchProfileMemberResponse.ReadOnly {
    override val member
        : Option[zio.aws.nimble.model.LaunchProfileMembership.ReadOnly] = scala
      .Option(impl.member())
      .map(value => zio.aws.nimble.model.LaunchProfileMembership.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberResponse
  ): zio.aws.nimble.model.UpdateLaunchProfileMemberResponse.ReadOnly =
    new Wrapper(impl)
}
