package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateLaunchProfileResponse(
    launchProfile: Option[zio.aws.nimble.model.LaunchProfile] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileResponse = {
    import UpdateLaunchProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileResponse
      .builder()
      .optionallyWith(launchProfile.map(value => value.buildAwsValue()))(
        _.launchProfile
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.UpdateLaunchProfileResponse.ReadOnly =
    zio.aws.nimble.model.UpdateLaunchProfileResponse.wrap(buildAwsValue())
}
object UpdateLaunchProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.UpdateLaunchProfileResponse =
      zio.aws.nimble.model.UpdateLaunchProfileResponse(
        launchProfile.map(value => value.asEditable)
      )
    def launchProfile: Option[zio.aws.nimble.model.LaunchProfile.ReadOnly]
    def getLaunchProfile
        : ZIO[Any, AwsError, zio.aws.nimble.model.LaunchProfile.ReadOnly] =
      AwsError.unwrapOptionField("launchProfile", launchProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileResponse
  ) extends zio.aws.nimble.model.UpdateLaunchProfileResponse.ReadOnly {
    override val launchProfile
        : Option[zio.aws.nimble.model.LaunchProfile.ReadOnly] = scala
      .Option(impl.launchProfile())
      .map(value => zio.aws.nimble.model.LaunchProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileResponse
  ): zio.aws.nimble.model.UpdateLaunchProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
