package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateStudioComponentResponse(
    studioComponent: Option[zio.aws.nimble.model.StudioComponent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.UpdateStudioComponentResponse = {
    import UpdateStudioComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.UpdateStudioComponentResponse
      .builder()
      .optionallyWith(studioComponent.map(value => value.buildAwsValue()))(
        _.studioComponent
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.UpdateStudioComponentResponse.ReadOnly =
    zio.aws.nimble.model.UpdateStudioComponentResponse.wrap(buildAwsValue())
}
object UpdateStudioComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.UpdateStudioComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.UpdateStudioComponentResponse =
      zio.aws.nimble.model.UpdateStudioComponentResponse(
        studioComponent.map(value => value.asEditable)
      )
    def studioComponent: Option[zio.aws.nimble.model.StudioComponent.ReadOnly]
    def getStudioComponent
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponent.ReadOnly] =
      AwsError.unwrapOptionField("studioComponent", studioComponent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStudioComponentResponse
  ) extends zio.aws.nimble.model.UpdateStudioComponentResponse.ReadOnly {
    override val studioComponent
        : Option[zio.aws.nimble.model.StudioComponent.ReadOnly] = scala
      .Option(impl.studioComponent())
      .map(value => zio.aws.nimble.model.StudioComponent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStudioComponentResponse
  ): zio.aws.nimble.model.UpdateStudioComponentResponse.ReadOnly = new Wrapper(
    impl
  )
}
