package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateStudioResponse(studio: zio.aws.nimble.model.Studio) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.UpdateStudioResponse = {
    import UpdateStudioResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.UpdateStudioResponse
      .builder()
      .studio(studio.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.UpdateStudioResponse.ReadOnly =
    zio.aws.nimble.model.UpdateStudioResponse.wrap(buildAwsValue())
}
object UpdateStudioResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.UpdateStudioResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.UpdateStudioResponse =
      zio.aws.nimble.model.UpdateStudioResponse(studio.asEditable)
    def studio: zio.aws.nimble.model.Studio.ReadOnly
    def getStudio: ZIO[Any, Nothing, zio.aws.nimble.model.Studio.ReadOnly] =
      ZIO.succeed(studio)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStudioResponse
  ) extends zio.aws.nimble.model.UpdateStudioResponse.ReadOnly {
    override val studio: zio.aws.nimble.model.Studio.ReadOnly =
      zio.aws.nimble.model.Studio.wrap(impl.studio())
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.UpdateStudioResponse
  ): zio.aws.nimble.model.UpdateStudioResponse.ReadOnly = new Wrapper(impl)
}
