package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.LaunchProfileValidationStatusMessage
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ValidationResult(
    state: zio.aws.nimble.model.LaunchProfileValidationState,
    statusCode: zio.aws.nimble.model.LaunchProfileValidationStatusCode,
    statusMessage: LaunchProfileValidationStatusMessage,
    `type`: zio.aws.nimble.model.LaunchProfileValidationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ValidationResult = {
    import ValidationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ValidationResult
      .builder()
      .state(state.unwrap)
      .statusCode(statusCode.unwrap)
      .statusMessage(
        LaunchProfileValidationStatusMessage.unwrap(
          statusMessage
        ): java.lang.String
      )
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ValidationResult.ReadOnly =
    zio.aws.nimble.model.ValidationResult.wrap(buildAwsValue())
}
object ValidationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ValidationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ValidationResult = zio.aws.nimble.model
      .ValidationResult(state, statusCode, statusMessage, `type`)
    def state: zio.aws.nimble.model.LaunchProfileValidationState
    def statusCode: zio.aws.nimble.model.LaunchProfileValidationStatusCode
    def statusMessage: LaunchProfileValidationStatusMessage
    def `type`: zio.aws.nimble.model.LaunchProfileValidationType
    def getState
        : ZIO[Any, Nothing, zio.aws.nimble.model.LaunchProfileValidationState] =
      ZIO.succeed(state)
    def getStatusCode: ZIO[
      Any,
      Nothing,
      zio.aws.nimble.model.LaunchProfileValidationStatusCode
    ] = ZIO.succeed(statusCode)
    def getStatusMessage
        : ZIO[Any, Nothing, LaunchProfileValidationStatusMessage] =
      ZIO.succeed(statusMessage)
    def getType
        : ZIO[Any, Nothing, zio.aws.nimble.model.LaunchProfileValidationType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ValidationResult
  ) extends zio.aws.nimble.model.ValidationResult.ReadOnly {
    override val state: zio.aws.nimble.model.LaunchProfileValidationState =
      zio.aws.nimble.model.LaunchProfileValidationState.wrap(impl.state())
    override val statusCode
        : zio.aws.nimble.model.LaunchProfileValidationStatusCode =
      zio.aws.nimble.model.LaunchProfileValidationStatusCode
        .wrap(impl.statusCode())
    override val statusMessage: LaunchProfileValidationStatusMessage =
      zio.aws.nimble.model.primitives
        .LaunchProfileValidationStatusMessage(impl.statusMessage())
    override val `type`: zio.aws.nimble.model.LaunchProfileValidationType =
      zio.aws.nimble.model.LaunchProfileValidationType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ValidationResult
  ): zio.aws.nimble.model.ValidationResult.ReadOnly = new Wrapper(impl)
}
