/*
 * Decompiled with CFR 0.152.
 */
package dk.nodes.nstack.kotlin.managers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import dk.nodes.nstack.kotlin.models.AppOpenResult;
import dk.nodes.nstack.kotlin.models.AppOpenSettings;
import dk.nodes.nstack.kotlin.models.AppUpdateData;
import dk.nodes.nstack.kotlin.models.AppUpdateResponse;
import dk.nodes.nstack.kotlin.models.Feedback;
import dk.nodes.nstack.kotlin.models.Proposal;
import dk.nodes.nstack.kotlin.models.RateReminder2;
import dk.nodes.nstack.kotlin.provider.HttpClientProvider;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ!\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J)\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J8\u0010!\u001a\u00020\u00142\u0018\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$\u0012\u0004\u0012\u00020\u00140#2\u0016\u0010&\u001a\u0012\u0012\b\u0012\u00060'j\u0002`(\u0012\u0004\u0012\u00020\u00140#J:\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00052\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140#2\u0016\u0010&\u001a\u0012\u0012\b\u0012\u00060'j\u0002`(\u0012\u0004\u0012\u00020\u00140#J\u001b\u0010+\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u00020\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u001b\u0010-\u001a\u0004\u0018\u00010\u00052\u0006\u0010.\u001a\u00020\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J:\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00052\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140#2\u0016\u0010&\u001a\u0012\u0012\b\u0012\u00060'j\u0002`(\u0012\u0004\u0012\u00020\u00140#J!\u0010/\u001a\u0002002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018JB\u0010/\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u00052\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u00140#2\u0016\u0010&\u001a\u0012\u0012\b\u0012\u00060'j\u0002`(\u0012\u0004\u0012\u00020\u00140#J\u0016\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u001bJT\u00106\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140;2\u0016\u0010&\u001a\u0012\u0012\b\u0012\u00060'j\u0002`(\u0012\u0004\u0012\u00020\u00140#J\u0016\u0010<\u001a\u00020\u00142\u0006\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u00020\u0007J\u0019\u0010?\u001a\u00020\u00142\u0006\u0010@\u001a\u00020AH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010BR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\u0005*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006C"}, d2={"Ldk/nodes/nstack/kotlin/managers/NetworkManager;", "", "client", "Lokhttp3/OkHttpClient;", "baseUrl", "", "debugMode", "", "(Lokhttp3/OkHttpClient;Ljava/lang/String;Z)V", "gson", "Lcom/google/gson/Gson;", "asJsonObject", "Lcom/google/gson/JsonObject;", "getAsJsonObject", "(Ljava/lang/String;)Lcom/google/gson/JsonObject;", "formatted", "Ljava/util/Date;", "getFormatted", "(Ljava/util/Date;)Ljava/lang/String;", "callActionEvents", "", "settings", "Ldk/nodes/nstack/kotlin/models/AppOpenSettings;", "action", "(Ldk/nodes/nstack/kotlin/models/AppOpenSettings;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "callAnswers", "rateReminderId", "", "answer", "(Ldk/nodes/nstack/kotlin/models/AppOpenSettings;ILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkRateReminder", "Ldk/nodes/nstack/kotlin/models/RateReminder2;", "(Ldk/nodes/nstack/kotlin/models/AppOpenSettings;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchProposals", "onSuccess", "Lkotlin/Function1;", "", "Ldk/nodes/nstack/kotlin/models/Proposal;", "onError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getResponse", "slug", "getResponseSync", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadTranslation", "url", "postAppOpen", "Ldk/nodes/nstack/kotlin/models/AppOpenResult;", "acceptLanguage", "Ldk/nodes/nstack/kotlin/models/AppUpdateData;", "postMessageSeen", "guid", "messageId", "postProposal", "locale", "key", "section", "newValue", "Lkotlin/Function0;", "postRateReminderSeen", "appOpenSettings", "rated", "sendFeedback", "feedback", "Ldk/nodes/nstack/kotlin/models/Feedback;", "(Ldk/nodes/nstack/kotlin/models/Feedback;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nstack-kotlin-core"})
public final class NetworkManager {
    private final Gson gson;
    private final OkHttpClient client;
    private final String baseUrl;
    private final boolean debugMode;

    public final void loadTranslation(@NotNull String url, @NotNull Function1<? super String, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        this.client.newCall(new Request.Builder().url(url).build()).enqueue(new Callback(this, onError, onSuccess){
            final /* synthetic */ NetworkManager this$0;
            final /* synthetic */ Function1 $onError;
            final /* synthetic */ Function1 $onSuccess;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$onError.invoke((Object)e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                try {
                    String json;
                    ResponseBody responseBody = response.body();
                    if (responseBody == null) {
                        Intrinsics.throwNpe();
                    }
                    String string = json = responseBody.string();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json");
                    JsonObject jsonObject = this.this$0.getAsJsonObject(string);
                    if (jsonObject == null) {
                        Intrinsics.throwNpe();
                    }
                    String string2 = jsonObject.getAsJsonObject("data").toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"json.asJsonObject!!.getA\u2026Object(\"data\").toString()");
                    this.$onSuccess.invoke((Object)string2);
                }
                catch (Exception e) {
                    this.$onError.invoke((Object)e);
                }
            }
            {
                this.this$0 = $outer;
                this.$onError = $captured_local_variable$1;
                this.$onSuccess = $captured_local_variable$2;
            }
        });
    }

    @Nullable
    public final Object loadTranslation(@NotNull String url, @NotNull Continuation<? super String> $completion) {
        String string;
        Response response = this.client.newCall(new Request.Builder().url(url).build()).execute();
        ResponseBody responseBody = response.body();
        Response response2 = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        if (response2.isSuccessful() && responseBody != null) {
            String string2 = responseBody.string();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"responseBody.string()");
            JsonObject jsonObject = this.getAsJsonObject(string2);
            string = String.valueOf(jsonObject != null ? jsonObject.getAsJsonObject("data") : null);
        } else {
            string = null;
        }
        return string;
    }

    public final void postAppOpen(@NotNull AppOpenSettings settings, @NotNull String acceptLanguage, @NotNull Function1<? super AppUpdateData, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)acceptLanguage, (String)"acceptLanguage");
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        FormBody.Builder formBuilder = new FormBody.Builder().add("guid", settings.getGuid()).add("version", settings.getVersion()).add("old_version", settings.getOldVersion()).add("platform", settings.getPlatform()).add("last_updated", this.getFormatted(settings.getLastUpdated())).add("dev", String.valueOf(this.debugMode)).add("test", String.valueOf(settings.getVersionUpdateTestMode()));
        Request request = new Request.Builder().url(this.baseUrl + "/api/v2/open").header("Accept-Language", acceptLanguage).post((RequestBody)formBuilder.build()).build();
        this.client.newCall(request).enqueue(new Callback(this, onError, onSuccess){
            final /* synthetic */ NetworkManager this$0;
            final /* synthetic */ Function1 $onError;
            final /* synthetic */ Function1 $onSuccess;

            public void onFailure(@Nullable Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$onError.invoke((Object)e);
            }

            public void onResponse(@Nullable Call call, @Nullable Response response) {
                try {
                    Response response2 = response;
                    String string = response2 != null && (response2 = response2.body()) != null ? response2.string() : null;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    String responseString = string;
                    AppUpdateResponse appUpdate = (AppUpdateResponse)NetworkManager.access$getGson$p(this.this$0).fromJson(responseString, AppUpdateResponse.class);
                    this.$onSuccess.invoke((Object)appUpdate.getData());
                }
                catch (Exception e) {
                    this.$onError.invoke((Object)e);
                }
            }
            {
                this.this$0 = $outer;
                this.$onError = $captured_local_variable$1;
                this.$onSuccess = $captured_local_variable$2;
            }
        });
    }

    @Nullable
    public final Object postAppOpen(@NotNull AppOpenSettings settings, @NotNull String acceptLanguage, @NotNull Continuation<? super AppOpenResult> $completion) {
        FormBody.Builder formBuilder = new FormBody.Builder().add("guid", settings.getGuid()).add("version", settings.getVersion()).add("old_version", settings.getOldVersion()).add("platform", settings.getPlatform()).add("last_updated", this.getFormatted(settings.getLastUpdated())).add("dev", String.valueOf(this.debugMode)).add("test", String.valueOf(settings.getVersionUpdateTestMode()));
        Request request = new Request.Builder().url(this.baseUrl + "/api/v2/open").header("Accept-Language", acceptLanguage).post((RequestBody)formBuilder.build()).build();
        try {
            Response response = this.client.newCall(request).execute();
            Object object = response;
            if (object == null || (object = object.body()) == null || (object = object.string()) == null) {
                return AppOpenResult.Failure.INSTANCE;
            }
            Object responseString = object;
            Object object2 = this.gson.fromJson((String)responseString, AppUpdateResponse.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gson.fromJson(\n         \u2026ava\n                    )");
            return new AppOpenResult.Success((AppUpdateResponse)object2);
        }
        catch (Exception e) {
            return AppOpenResult.Failure.INSTANCE;
        }
    }

    public final void postMessageSeen(@NotNull String guid, int messageId) {
        Intrinsics.checkParameterIsNotNull((Object)guid, (String)"guid");
        FormBody.Builder formBuilder = new FormBody.Builder().add("guid", guid).add("message_id", String.valueOf(messageId));
        Request request = new Request.Builder().url(this.baseUrl + "/api/v1/notify/messages/views").post((RequestBody)formBuilder.build()).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            }
        });
    }

    public final void postRateReminderSeen(@NotNull AppOpenSettings appOpenSettings, boolean rated) {
        Intrinsics.checkParameterIsNotNull((Object)appOpenSettings, (String)"appOpenSettings");
        String answer = rated ? "yes" : "no";
        FormBody.Builder formBuilder = new FormBody.Builder().add("guid", appOpenSettings.getGuid()).add("platform", appOpenSettings.getPlatform()).add("answer", answer);
        Request request = new Request.Builder().url(this.baseUrl + "/api/v1/notify/rate_reminder/views").post((RequestBody)formBuilder.build()).build();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            }
        });
    }

    public final void getResponse(@NotNull String slug, @NotNull Function1<? super String, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)slug, (String)"slug");
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        Request request = new Request.Builder().url(this.baseUrl + "/api/v1/content/responses/" + slug).get().build();
        this.client.newCall(request).enqueue(new Callback(onError, onSuccess, slug){
            final /* synthetic */ Function1 $onError;
            final /* synthetic */ Function1 $onSuccess;
            final /* synthetic */ String $slug;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$onError.invoke((Object)e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                ResponseBody responseBody = response.body();
                if (response.isSuccessful() && responseBody != null) {
                    String string = responseBody.string();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"responseBody.string()");
                    this.$onSuccess.invoke((Object)string);
                } else {
                    this.$onError.invoke((Object)new RuntimeException(this.$slug + " returned: " + response.code()));
                }
            }
            {
                this.$onError = $captured_local_variable$0;
                this.$onSuccess = $captured_local_variable$1;
                this.$slug = $captured_local_variable$2;
            }
        });
    }

    @Nullable
    public final Object getResponseSync(@NotNull String slug, @NotNull Continuation<? super String> $completion) {
        Request request = new Request.Builder().url(this.baseUrl + "/api/v1/content/responses/" + slug).get().build();
        Response response = this.client.newCall(request).execute();
        ResponseBody responseBody = response.body();
        Response response2 = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        return response2.isSuccessful() && responseBody != null ? responseBody.string() : null;
    }

    public final void postProposal(@NotNull AppOpenSettings settings, @NotNull String locale, @NotNull String key, @NotNull String section, @NotNull String newValue, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)section, (String)"section");
        Intrinsics.checkParameterIsNotNull((Object)newValue, (String)"newValue");
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        FormBody.Builder formBuilder = new FormBody.Builder().add("key", key).add("section", section).add("value", newValue).add("locale", locale).add("guid", settings.getGuid()).add("platform", "mobile");
        Request request = new Request.Builder().url(this.baseUrl + "/api/v2/content/localize/proposals").post((RequestBody)formBuilder.build()).build();
        this.client.newCall(request).enqueue(new Callback(this, onError, onSuccess){
            final /* synthetic */ NetworkManager this$0;
            final /* synthetic */ Function1 $onError;
            final /* synthetic */ Function0 $onSuccess;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$onError.invoke((Object)e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                JsonObject jsonObject;
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                Object object = response.body();
                JsonObject jsonObject2 = object != null && (object = object.string()) != null ? this.this$0.getAsJsonObject((String)object) : (jsonObject = null);
                if (jsonObject != null && jsonObject.has("data")) {
                    this.$onSuccess.invoke();
                } else {
                    this.$onError.invoke((Object)new IOException());
                }
            }
            {
                this.this$0 = $outer;
                this.$onError = $captured_local_variable$1;
                this.$onSuccess = $captured_local_variable$2;
            }
        });
    }

    public final void fetchProposals(@NotNull Function1<? super List<Proposal>, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        Request request = new Request.Builder().url(this.baseUrl + "/api/v2/content/localize/proposals").get().build();
        this.client.newCall(request).enqueue(new Callback(this, onError, onSuccess){
            final /* synthetic */ NetworkManager this$0;
            final /* synthetic */ Function1 $onError;
            final /* synthetic */ Function1 $onSuccess;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$onError.invoke((Object)e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                try {
                    List proposals;
                    ResponseBody responseBody = response.body();
                    String responseString = responseBody != null ? responseBody.string() : null;
                    Type listType2 = new TypeToken<List<? extends Proposal>>(){}.getType();
                    Gson gson = NetworkManager.access$getGson$p(this.this$0);
                    String string = responseString;
                    JsonElement jsonElement = string != null && (string = this.this$0.getAsJsonObject(string)) != null ? string.get("data") : null;
                    if (jsonElement == null) {
                        Intrinsics.throwNpe();
                    }
                    List list = proposals = (List)gson.fromJson(jsonElement, listType2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"proposals");
                    this.$onSuccess.invoke((Object)list);
                }
                catch (Exception e) {
                    this.$onError.invoke((Object)e);
                }
            }
            {
                this.this$0 = $outer;
                this.$onError = $captured_local_variable$1;
                this.$onSuccess = $captured_local_variable$2;
            }
        });
    }

    @Nullable
    public final JsonObject getAsJsonObject(@NotNull String $this$asJsonObject) {
        JsonObject jsonObject;
        Intrinsics.checkParameterIsNotNull((Object)$this$asJsonObject, (String)"$this$asJsonObject");
        try {
            jsonObject = (JsonObject)this.gson.fromJson($this$asJsonObject, JsonObject.class);
        }
        catch (Exception e) {
            jsonObject = null;
        }
        return jsonObject;
    }

    private final String getFormatted(@NotNull Date $this$formatted) {
        String string = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.getDefault()).format($this$formatted);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SimpleDateFormat(DATE_FO\u2026etDefault()).format(this)");
        return string;
    }

    @Nullable
    public final Object checkRateReminder(@NotNull AppOpenSettings settings, @NotNull Continuation<? super RateReminder2> $completion) {
        Response response;
        Request request = new Request.Builder().url(this.baseUrl + "/api/v2/notify/rate_reminder_v2?guid=" + settings.getGuid()).get().build();
        Response response2 = response = this.client.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        if (response2.isSuccessful()) {
            RateReminder2 rateReminder2;
            Object object = response.body();
            if (object != null && (object = object.string()) != null && (object = this.getAsJsonObject((String)object)) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                rateReminder2 = new RateReminder2((JsonObject)it);
            } else {
                rateReminder2 = null;
            }
            return rateReminder2;
        }
        return null;
    }

    @Nullable
    public final Object callActionEvents(@NotNull AppOpenSettings settings, @NotNull String action, @NotNull Continuation<? super Unit> $completion) {
        FormBody body = new FormBody.Builder().add("guid", settings.getGuid()).add("action", action).build();
        Request request = new Request.Builder().url(this.baseUrl + "/api/v2/notify/rate_reminder_v2/events").post((RequestBody)body).build();
        this.client.newCall(request).execute();
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object callAnswers(@NotNull AppOpenSettings settings, int rateReminderId, @NotNull String answer, @NotNull Continuation<? super Unit> $completion) {
        FormBody body = new FormBody.Builder().add("guid", settings.getGuid()).add("answer", answer).build();
        Request request = new Request.Builder().url(this.baseUrl + "/api/v2/notify/rate_reminder_v2/" + rateReminderId + "/answers").post((RequestBody)body).build();
        this.client.newCall(request).execute();
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object sendFeedback(@NotNull Feedback feedback, @NotNull Continuation<? super Unit> $completion) {
        String it;
        boolean bl;
        boolean bl2;
        String string;
        FormBody.Builder builder = new FormBody.Builder();
        boolean bl3 = false;
        boolean bl4 = false;
        FormBody.Builder $this$apply = builder;
        boolean bl5 = false;
        String string2 = feedback.getAppVersion();
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl6 = false;
            $this$apply.add("app_version", it);
        }
        String string3 = feedback.getDeviceName();
        if (string3 != null) {
            string = string3;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl7 = false;
            $this$apply.add("device", it);
        }
        String string4 = feedback.getName();
        if (string4 != null) {
            string = string4;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl8 = false;
            $this$apply.add("name", it);
        }
        String string5 = feedback.getEmail();
        if (string5 != null) {
            string = string5;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl9 = false;
            $this$apply.add("email", it);
        }
        String string6 = feedback.getMessage();
        if (string6 != null) {
            string = string6;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl10 = false;
            $this$apply.add("message", it);
        }
        FormBody body = builder.build();
        Request request = new Request.Builder().url(this.baseUrl + "/api/v2/ugc/feedbacks").post((RequestBody)body).build();
        this.client.newCall(request).execute();
        return Unit.INSTANCE;
    }

    public NetworkManager(@NotNull OkHttpClient client, @NotNull String baseUrl, boolean debugMode) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        this.client = client;
        this.baseUrl = baseUrl;
        this.debugMode = debugMode;
        this.gson = HttpClientProvider.INSTANCE.provideGson$nstack_kotlin_core();
    }

    public static final /* synthetic */ Gson access$getGson$p(NetworkManager $this) {
        return $this.gson;
    }
}

