/*
 * Decompiled with CFR 0.152.
 */
package dk.nodes.nstack.kotlin.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Ldk/nodes/nstack/kotlin/util/DateDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Ljava/util/Date;", "()V", "deserialize", "jsonElement", "Lcom/google/gson/JsonElement;", "typeOF", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "Companion", "nstack-kotlin-core"})
public final class DateDeserializer
implements JsonDeserializer<Date> {
    private static final HashMap<String, SimpleDateFormat> formatters;
    @NotNull
    private static final String[] DATE_FORMATS;
    @NotNull
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final Companion Companion;

    @NotNull
    public Date deserialize(@NotNull JsonElement jsonElement, @NotNull Type typeOF, @NotNull JsonDeserializationContext context) throws JsonParseException {
        Intrinsics.checkParameterIsNotNull((Object)jsonElement, (String)"jsonElement");
        Intrinsics.checkParameterIsNotNull((Object)typeOF, (String)"typeOF");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        for (String format : DATE_FORMATS) {
            if (!formatters.containsKey(format)) {
                ((Map)formatters).put(format, new SimpleDateFormat(format, Locale.getDefault()));
            }
            try {
                Cloneable cloneable = formatters.get(format);
                if (cloneable == null || (cloneable = cloneable.parse(jsonElement.getAsString())) == null) {
                    cloneable = new Date();
                }
                return cloneable;
            }
            catch (ParseException parseException) {
            }
        }
        throw (Throwable)new JsonParseException("Unparseable date: \"" + jsonElement.getAsString() + "\". Supported formats: " + Arrays.toString(DATE_FORMATS));
    }

    static {
        Companion = new Companion(null);
        formatters = new HashMap();
        DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss'Z'", DATE_FORMAT, "yyyy-MM-dd", "MMM dd, yyyy hh:mm:ss aaa"};
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldk/nodes/nstack/kotlin/util/DateDeserializer$Companion;", "", "()V", "DATE_FORMAT", "", "DATE_FORMATS", "", "getDATE_FORMATS", "()[Ljava/lang/String;", "[Ljava/lang/String;", "formatters", "Ljava/util/HashMap;", "Ljava/text/SimpleDateFormat;", "nstack-kotlin-core"})
    public static final class Companion {
        @NotNull
        public final String[] getDATE_FORMATS() {
            return DATE_FORMATS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

